<?php

namespace Limb_Chatbot\Includes\Exceptions;

/**
 * Class Error_Codes
 *
 * Defines error code constants used throughout the Limb Chatbot system.
 * These codes are grouped by categories such as validation, chatbot, authentication,
 * data handling, AI provider errors, file errors, system errors, and vector DB errors.
 *
 * @since 1.0.0
 * @since 1.0.9 Added Claude
 */
class Error_Codes {

	// 10000 - 10099: Validation errors.
	// Errors related to invalid inputs, incorrect formats, or missing required values
	const VALIDATION_BAD_BASE64 = 10006;  // Bad base64 format error
	const VALIDATION_UNSUPPORTED_MIME_TYPE = 10007;  // Unsupported mime type error
	const VALIDATION_VALUE_EXISTS = 10008;  // Value already exists error
	const VALIDATION_INVALID_VALUE = 10009; // Invalid value error
	const VALIDATION_REQUIRED = 10010; // Required value missing error
	const VALIDATION_UNSUPPORTED_VALUE = 10011; // Unsupported value
	const VALIDATION_INVALID_OR_MISSING_FILE = 10012; // Unsupported value
	const VALIDATION_UNEXPECTED_CSV_COLUMN = 10013; // Unsupported value
	const VALIDATION_FILE_SIZE_LIMIT = 10014; // File size exceeds the limit


	// 10100 - 10199: Chatbot-related errors.
	// Errors related to chatbot message handling, processing, and communication with the user
	const CHATBOT_MESSAGE_ALREADY_SENT = 10101;  // Message already sent error
	const CHATBOT_LIMIT_EXCEED = 10102;  // Chatbot limit exceed error
	const CHATBOT_NO_ACTIVE_USER_MESSAGE = 10104;  // No active user message error
	const CHATBOT_NO_MESSAGES = 10105;  // No messages to process error
	const CHATBOT_PROMPT_MISSING = 10106; // Missing user prompt error
	const CHATBOT_REQUEST_IN_PROGRESS = 10107; // Request in progress error
	const CHATBOT_FAILED_REPLY = 10108; // Failed to generate a reply error
	const CHATBOT_SYSTEM_MESSAGE_IS_MISSING = 10109; // Failed to generate a reply error


	// 10200 - 10299: Authentication/Configuration errors.
	// Errors related to API key, user authentication, and system configuration issues
	const AUTHENTICATION_API_KEY_MISSING = 10200;  // Missing API key error
	const AUTHENTICATION_UNAUTHORIZED = 10201; // Unauthorized access error
	const QUOTA_EXCEED = 10202;


	// 10300 - 10399: Data handling and argument validation errors.
	// Errors related to invalid data or incorrect arguments passed to functions
	const DATA_INVALID_VECTOR_ARGUMENT = 10301;  // Invalid vector argument error
	const DATA_INVALID_AI_MODEL_ARGUMENT = 10302;  // Invalid ai model argument error


	// 10700 - 10799: AI Provider general errors.
	// Errors related to the AI provider setup or communication issues
	const AI_PROVIDER_NOT_SET = 10700;  // AI provider not set error
	const AI_PROVIDER_MISSING_UTILITY = 10701;  // AI provider utility missing error
	const AI_MODEL_NOT_SET = 10702;  // AI model not set error


	// 10600 - 10699: File upload/download errors.
	// Errors related to file handling, attachment issues, and upload/download failures
	const FILE_UNABLE_TO_HANDLE_ATTACHMENT = 10604;  // Unable to handle attachment error
	const FILE_UNABLE_TO_CREATE_UPLOAD_DIRECTORY = 10605;
	const FILE_FAILED_TO_MOVE_UPLOADED_FILE = 10606;
	const FILE_FAILED_TO_OPEN = 10607;
	const CSV_FILE_MISSING_OR_INVALID_HEADER = 10608;
	const CSV_FILE_IS_NOT_OPEN = 10609;
	const DATASET_FILE_UPLOAD_MISSING_FILE = 10610;
	const DATASET_FILE_IS_MISSING = 10611;
	const DATASET_FILE_IS_EMPTY = 10612;
	const FILE_FAILED_TO_CREATE = 10613;
	const FILE_NOT_FOUND = 10614;

	// 10700 - 10799: AI Provider-specific errors.
	// Errors from specific AI providers (e.g., Gemini, OpenAI, DeepSeek, Claude, Grok)
	const GEMINI_ERROR = 10700;  // Gemini AI provider error
	const OPEN_AI_ERROR = 10701; // OpenAI provider error
	const DEEP_SEEK_ERROR = 10702; // DeepSeek AI provider error
	const CLAUDE_ERROR = 10703; // Claude AI provider error
	const XAI_ERROR = 10704; // Grok (xAI) provider error


	// 10800 - 10899: System general errors
	// General system errors, unexpected responses, missing values, and unsupported features
	const TECHNICAL_ERROR = 10801;  // General technical error
	const UNEXPECTED_RESPONSE_FORMAT = 10802;  // Unexpected response format error
	const NOT_SUPPORTED = 10803;  // Feature not supported error
	const MISSING_VALUE = 10804;  // Missing value error
	const EMPTY_VALUE = 10805;  // Empty value error
	const NOT_FOUND = 10807;  // Not found error

	// 10900 - 10999: Vector DB specific errors
	const PINECONE_ERROR = 10901;

	// 11000 - 11100: Errors thrown during user message
	const USER_MESSAGE_LIMIT_EXCEED = 11000;
	const USER_MESSAGE_PREPARATION_FAILED = 11001;  // Message preparation failed error
	const USER_MESSAGE_FAILED = 11002;
	const AI_RESPONSE_FAILED = 11101;


	// 11200 - 11299: Errors related to jobs
	const TASK_PROCESSING_FAILED = 11200;

}
