<?php

namespace Limb_Chatbot\Includes\Data_Schemas;

use Limb_Chatbot\Includes\Scheme_Interface;

/**
 * Class Chatbot_Meta
 *
 * Handles schema rules for chatbot-related settings and metadata.
 *
 * Extends the `Setting` class and implements the `Scheme_Interface` for
 * schema validation and preview support.
 *
 * @since 1.0.0
 */
class Chatbot_Meta extends Setting implements Scheme_Interface {

	/**
	 * Get the validation rules for chatbot meta.
	 *
	 * @param bool $preview Whether to return preview rules or not.
	 * @return array Validation rules as key-value pairs.
	 * @since 1.0.0
	 */
	public static function rules( $preview = false ): array {
		return $preview ? self::apply_preview_postfix( self::chatbot_rules( '_' ) ) : self::chatbot_rules( '_' );
	}
}