<?php

namespace Limb_Chatbot\Includes\Data_Objects;

class Wp_Special_Page_Object_Group extends Wp_Object_Group {
	/**
	 * Retrieve special page object groups
	 *
	 * @return array
	 */
	public static function all(): array {
		$show_on_front = get_option( 'show_on_front', 'posts' );
		$groups = [];

		// Always add the Homepage group
		$groups[] = self::make( [
			'name'  => 'homepage',
			'label' => __( 'Homepage', 'limb-chatbot' )
		] );

		// Add Posts Page group only if show_on_front is 'page'
		if ( $show_on_front === 'page' ) {
			$groups[] = self::make( [
				'name'  => 'posts_page',
				'label' => __( 'Posts Page', 'limb-chatbot' )
			] );
		}

		return $groups;
	}
}

