<?php

namespace Limb_Chatbot\Includes\Data_Objects;

class Wp_Post_Object_Group extends Wp_Object_Group {
	/**
	 * Retrieve all the post groups
	 *
	 * @return array
	 */
	public static function all(): array {
		$post_groups = [];
		foreach ( parent::get_post_types() as $post_type_key => $post_type_obj ) {
			// Check if post type has at least one published post
			$count = wp_count_posts( $post_type_key );
			$has_posts = false;

			if ( $count ) {
				foreach ( $count as $status => $num ) {
					if ( $status === 'publish' && $num > 0 ) {
						$has_posts = true;
						break;
					}
				}
			}

			// Skip post types with no published posts
			if ( ! $has_posts ) {
				continue;
			}

			$post_groups[] = self::make( [
				'name'  => $post_type_key,
				'label' => $post_type_obj->label,
			] );
		}

		return $post_groups;
	}
}