<?php

namespace Limb_Chatbot\Includes\Data_Objects;


use Limb_Chatbot\Includes\Database_Strategies\WPDB;
use Limb_Chatbot\Includes\Database_Strategy_Interface;

class Wp_Object extends Data_Object {

	/**
	 * ID of the object
	 *
	 * @var
	 */
	public $id;

	/**
	 * Title of the object
	 *
	 * @var
	 */
	public $title;

	/**
	 * Link to the object
	 *
	 * @var
	 */
	public $link;

	/**
	 * The identifier matching page context format
	 *
	 * @var
	 */
	public $identifier;

	/**
	 * The post type or taxonomy name
	 *
	 * @var
	 */
	public $object_type;

	/**
	 * Create new instance
	 *
	 * @param  array  $data
	 *
	 * @return self
	 */
	public static function create( $data ): object {
		return new self;
	}

	/**
	 * Find instance
	 *
	 * @param  int|null  $id
	 *
	 * @return self|null
	 */
	public static function find( $id ): ?object {
		return new self;
	}

	static function get_db_strategy(): ?Database_Strategy_Interface {
		return WPDB::instance();
	}

	/**
	 * Get the object id
	 *
	 * @return mixed
	 */
	public function get_id() {
		return $this->id;
	}

	/**
	 * Set the object id
	 *
	 * @param  mixed  $id
	 */
	public function set_id( $id ): void {
		$this->id = $id;
	}

	/**
	 * Get the title
	 *
	 * @return mixed
	 */
	public function get_title() {
		return $this->title;
	}

	/**
	 * Set the title
	 *
	 * @param  mixed  $title
	 */
	public function set_title( $title ): void {
		$this->title = $title;
	}

	/**
	 * Get the link
	 *
	 * @return mixed
	 */
	public function get_link() {
		return $this->link;
	}

	/**
	 * Set link
	 *
	 * @param  mixed  $link
	 */
	public function set_link( $link ): void {
		$this->link = $link;
	}

	/**
	 * Get the identifier
	 *
	 * @return mixed
	 */
	public function get_identifier() {
		return $this->identifier;
	}

	/**
	 * Set identifier
	 *
	 * @param  mixed  $identifier
	 */
	public function set_identifier( $identifier ): void {
		$this->identifier = $identifier;
	}

	/**
	 * Get object type
	 *
	 * @return mixed
	 */
	public function get_object_type() {
		return $this->object_type;
	}

	/**
	 * Set object type
	 *
	 * @param  mixed  $object_type
	 */
	public function set_object_type( $object_type ): void {
		$this->object_type = $object_type;
	}
}