<?php

namespace Limb_Chatbot\Includes\Data_Objects;

use Limb_Chatbot\Includes\Database_Strategies\WPDB;
use Limb_Chatbot\Includes\Database_Strategy_Interface;
use Limb_Chatbot\Includes\Factories\Wp_Object_Repository_Factory;

class Wp_Object_Group extends Data_Object {

	/**
	 * Group name
	 *
	 * @var
	 */
	public $name;

	/**
	 * Group label
	 *
	 * @var
	 */
	public $label;

	/**
	 * @json_excluded
	 * @var array|string[]
	 */
	protected array $meta_properties = array('objects');

	/**
	 * @json_excluded
	 * @var array
	 */
	public array $included = [];

	/**
	 * Create a new instance
	 *
	 * @param  array  $data
	 *
	 * @return self
	 */
	public static function create( $data ): object {
		return new self;
	}

	/**
	 * Get all groups
	 *
	 * @return array
	 */
	public static function all(): array {
		return [];
	}

	static function get_db_strategy(): ?Database_Strategy_Interface {
		return WPDB::instance();
	}

	/**
	 * Get the post types
	 *
	 * @return string[]|\WP_Post_Type[]
	 */
	protected static function get_post_types() {
		$post_types = get_post_types( [ 'public' => true ], 'objects' );
		$exclude    = [ 'attachment', 'revision', 'nav_menu_item' ];
		foreach ( $exclude as $unset ) {
			unset( $post_types[ $unset ] );
		}

		return $post_types;
	}

	/**
	 * Find the instance
	 *
	 * @param  int|null  $id
	 *
	 * @return self|null
	 */
	public static function find( $id ): ?object {
		return new self;
	}

	/**
	 * Get the group name
	 *
	 * @return mixed
	 */
	public function get_label() {
		return $this->label;
	}

	/**
	 * Set the group name
	 *
	 * @param  mixed  $label
	 */
	public function set_label( $label ): void {
		$this->label = $label;
	}

	/**
	 * Get the objects
	 *
	 * @return array
	 */
	public function objects( $search_term, $per_page, $page ) {
		$object_repository = ( new Wp_Object_Repository_Factory() )->make( $this->get_name() );

		return $object_repository->get_items( $this->get_name(), $search_term, $per_page, $page );
	}

	/**
	 * Get the group name
	 *
	 * @return mixed
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Set the group name
	 *
	 * @param  mixed  $name
	 */
	public function set_name( $name ): void {
		$this->name = $name;
	}
}