<?php

namespace Limb_Chatbot\Includes\Data_Objects;

class Wp_Archive_Object_Group extends Wp_Object_Group {
	/**
	 * Retrieve archive object groups
	 *
	 * @return array
	 */
	public static function all(): array {
		// Check if there are any archives available
		$post_types_with_archives = get_post_types( [ 'public' => true, 'has_archive' => true ], 'objects' );
		$post_post_type = get_post_type_object( 'post' );
		if ( $post_post_type && ! isset( $post_types_with_archives['post'] ) ) {
			$post_types_with_archives['post'] = $post_post_type;
		}

		// Only return if we have archives
		if ( empty( $post_types_with_archives ) ) {
			return [];
		}

		return array(
			self::make( [
				'name'  => 'archives',
				'label' => __( 'Archives', 'limb-chatbot' )
			] )
		);
	}
}