<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Class Vector_Index_Vector
 *
 * Represents the pivot relation between vectors and vector indexes.
 *
 * @since 1.0.0
 */
class Vector_Index_Vector extends WPDB_Data_Object {

	/**
	 * Columns that can be mass-assigned.
	 *
	 * @since 1.0.0
	 */
	const FILLABLE = array( 'vector_id', 'vector_index_id' );

	/**
	 * The name of the database table.
	 *
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_vector_indexes_vectors';

	/**
	 * @var int The ID of the vector.
	 * @since 1.0.0
	 */
	public int $vector_id;

	/**
	 * @var int The ID of the vector index.
	 * @since 1.0.0
	 */
	public int $vector_index_id;

	/**
	 * Get the vector ID.
	 *
	 * @return int The ID of the vector.
	 * @since 1.0.0
	 */
	public function get_vector_id(): int {
		return $this->vector_id;
	}

	/**
	 * Set the vector ID.
	 *
	 * @param int $vector_id The ID of the vector.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_vector_id( int $vector_id ): void {
		$this->vector_id = $vector_id;
	}

	/**
	 * Get the vector index ID.
	 *
	 * @return int The ID of the vector index.
	 * @since 1.0.0
	 */
	public function get_vector_index_id(): int {
		return $this->vector_index_id;
	}

	/**
	 * Set the vector index ID.
	 *
	 * @param int $vector_index_id The ID of the vector index.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_vector_index_id( int $vector_index_id ): void {
		$this->vector_index_id = $vector_index_id;
	}
}