<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Class Vector_Index_Meta
 *
 * Represents metadata for a vector index.
 *
 * @since 1.0.0
 */
class Vector_Index_Meta extends Meta_Data_Object {

	/**
	 * List of fillable columns for database operations.
	 *
	 * @since 1.0.0
	 */
	const FILLABLE = array( 'meta_key', 'meta_value', 'vector_index_id' );

	/**
	 * Name of the database table.
	 *
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_vector_index_metas';

	/**
	 * @var int|null Foreign key reference to the associated vector index.
	 * @since 1.0.0
	 */
	public ?int $vector_index_id = null;

	/**
	 * Get the associated vector index ID.
	 *
	 * @return int|null The vector index ID.
	 * @since 1.0.0
	 */
	public function get_vector_index_id(): ?int {
		return $this->vector_index_id;
	}

	/**
	 * Set the associated vector index ID.
	 *
	 * @param  int|null  $vector_index_id  The vector index ID.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_vector_index_id( ?int $vector_index_id ): void {
		$this->vector_index_id = $vector_index_id;
	}
}