<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Class User_Limit
 *
 * Represents a user-specific limit extending the base Limit class.
 *
 * @since 1.0.0
 */
class User_Limit extends Limit {

	/**
	 * The Chatbot user associated with this limit.
	 *
	 * @var Chatbot_User|null
	 * @since 1.0.0
	 */
	public ?Chatbot_User $chatbot_user = null;

	/**
	 * Get the associated Chatbot user.
	 *
	 * @return Chatbot_User|null The chatbot user object or null if not set.
	 * @since 1.0.0
	 */
	public function get_chatbot_user(): ?Chatbot_User {
		return $this->chatbot_user;
	}
}
