<?php

namespace Limb_Chatbot\Includes\Data_Objects;

use Limb_Chatbot\Includes\Database_Strategy_Interface;

/**
 * Class Token_Usage
 *
 * This data object has no relation with a database.
 * It is designed to facilitate interactions between objects,
 * and can be used later for total token calculations in the admin panel.
 *
 * @since 1.0.0
 */
class Token_Usage extends Data_Object {

	/**
	 * Number of input tokens used.
	 *
	 * @var int|null
	 * @since 1.0.0
	 */
	public $input_tokens;

	/**
	 * Number of output tokens used.
	 *
	 * @var int|null
	 * @since 1.0.0
	 */
	public $output_tokens;

	/**
	 * Additional details about the token usage.
	 *
	 * @var array
	 * @since 1.0.0
	 */
	public $details = [];

	/**
	 * The AI model associated with this token usage.
	 *
	 * @var AI_Model|null
	 * @since 1.0.0
	 */
	public ?AI_Model $model;

	/**
	 * No DB strategy since this is not a DB-backed object.
	 *
	 * @return Database_Strategy_Interface|null
	 * @since 1.0.0
	 */
	static function get_db_strategy(): ?Database_Strategy_Interface {
		return null;
	}

	/**
	 * Get the number of input tokens.
	 *
	 * @return int|null
	 * @since 1.0.0
	 */
	public function get_input_tokens() {
		return $this->input_tokens;
	}

	/**
	 * Set the number of input tokens.
	 *
	 * @param int|null $input_tokens
	 * @return void
	 * @since 1.0.0
	 */
	public function set_input_tokens( $input_tokens ): void {
		$this->input_tokens = $input_tokens;
	}

	/**
	 * Get the number of output tokens.
	 *
	 * @return int|null
	 * @since 1.0.0
	 */
	public function get_output_tokens() {
		return $this->output_tokens;
	}

	/**
	 * Set the number of output tokens.
	 *
	 * @param int|null $output_tokens
	 * @return void
	 * @since 1.0.0
	 */
	public function set_output_tokens( $output_tokens ): void {
		$this->output_tokens = $output_tokens;
	}

	/**
	 * Get the associated AI model.
	 *
	 * @return AI_Model|null
	 * @since 1.0.0
	 */
	public function get_model(): ?AI_Model {
		return $this->model;
	}

	/**
	 * Set the associated AI model.
	 *
	 * @param AI_Model|null $model
	 * @return void
	 * @since 1.0.0
	 */
	public function set_model( ?AI_Model $model ): void {
		$this->model = $model;
	}
}