<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Class Message_Meta
 *
 * Represents metadata associated with a chat message.
 *
 * @since 1.0.0
 */
class Message_Meta extends Meta_Data_Object {

	/**
	 * Database table name.
	 *
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_chat_message_metas';

	/**
	 * Fillable fields for mass assignment.
	 *
	 * @since 1.0.0
	 *
	 * @var string[]
	 */
	const FILLABLE
		= [
			'message_id',
			'meta_key',
			'meta_value',
		];

	/**
	 * ID of the related message.
	 *
	 * @var int|null
	 * @since 1.0.0
	 */
	public $message_id;

	/**
	 * Get the ID of the related message.
	 *
	 * @return int|null
	 * @since 1.0.0
	 */
	public function get_message_id() {
		return $this->message_id;
	}

	/**
	 * Set the ID of the related message.
	 *
	 * @param  int|null  $message_id
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_message_id( $message_id ) {
		$this->message_id = $message_id;
	}

	public function message() {
		return Message::find( $this->get_message_id() );
	}
}
