<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Represents a limit configuration specific to a guest chatbot user.
 *
 * @since 1.0.0
 */
class Guest_Limit extends Limit {

	/**
	 * The chatbot user this limit applies to.
	 *
	 * @var Chatbot_User|null
	 * @since 1.0.0
	 */
	public ?Chatbot_User $chatbot_user = null;

	/**
	 * Retrieves the chatbot user associated with this guest limit.
	 *
	 * @return Chatbot_User|null The chatbot user, or null if not set.
	 * @since 1.0.0
	 */
	public function get_chatbot_user(){
		return $this->chatbot_user;
	}
}