<?php

namespace Limb_Chatbot\Includes\Data_Objects;


/**
 * Represents a message that can be embedded in a vector index.
 *
 * @since 1.0.0
 */
class Embeddable_Message extends Message {

	/**
	 * Vector index IDs associated with this message.
	 *
	 * @var array|null
	 * @since 1.0.0
	 */
	public ?array $vector_index_ids = [];

	/**
	 * Get the vector index IDs associated with the message.
	 *
	 * @return array|null
	 * @since 1.0.0
	 */
	public function get_vector_index_ids(): ?array {
		return $this->vector_index_ids;
	}

	/**
	 * Set the vector index IDs for the message.
	 *
	 * @param array|null $vector_index_ids Array of vector index IDs.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_vector_index_ids( ?array $vector_index_ids ): void {
		$this->vector_index_ids = $vector_index_ids;
	}
}