<?php

namespace Limb_Chatbot\Includes\Data_Objects;


/**
 * Represents metadata for a dataset entry.
 *
 * @since 1.0.0
 */
class Dataset_Meta extends Meta_Data_Object {

	/**
	 * The list of fillable fields for mass assignment.
	 *
	 * @since 1.0.0
	 */
	const FILLABLE = array( 'meta_key', 'meta_value', 'dataset_id' );

	/**
	 * The name of the database table for dataset metadata.
	 *
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_dataset_metas';

	/**
	 * Meta key used to determine sync status.
	 *
	 * @since 1.0.0
	 */
	const SYNCED_KEY = 'synced';

	/**
	 * Value representing a synced vector.
	 *
	 * @since 1.0.0
	 */
	const SYNCED_YES_VALUE = 1;

	/**
	 * Value representing a non-synced vector.
	 *
	 * @since 1.0.0
	 */
	const SYNCED_NO_VALUE = 0;


	/**
	 * The ID of the associated dataset.
	 *
	 * @var int
	 * @since 1.0.0
	 */
	public int $dataset_id;

	/**
	 * Get the associated dataset ID.
	 *
	 * @return int Dataset ID.
	 * @since 1.0.0
	 */
	public function get_dataset_id(): int {
		return $this->dataset_id;
	}

	/**
	 * Set the associated dataset ID.
	 *
	 * @param int $dataset_id Dataset ID to assign.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_dataset_id( int $dataset_id ): void {
		$this->dataset_id = $dataset_id;
	}

	public function dataset() {
		return Dataset::find( $this->get_dataset_id() );
	}
}