<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Class Chatbot_User_Meta
 *
 * Represents metadata entries associated with a chatbot user.
 *
 * @package Limb_Chatbot\Includes\Data_Objects
 * @since 1.0.0
 */
class Chatbot_User_Meta extends Meta_Data_Object {

	/**
	 * The database table name.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_user_metas';

	/**
	 * The fields that can be mass-assigned.
	 *
	 * @var array
	 * @since 1.0.0
	 */
	const FILLABLE = [
		'id',
		'chatbot_user_id',
		'meta_key',
		'meta_value',
	];

	/**
	 * The associated chatbot user ID.
	 *
	 * @var int
	 * @since 1.0.0
	 */
	public $chatbot_user_id;

	/**
	 * Get the associated chatbot user ID.
	 *
	 * @return int Chatbot user ID.
	 * @since 1.0.0
	 */
	public function get_chatbot_user_id() {
		return $this->chatbot_user_id;
	}

	/**
	 * Set the associated chatbot user ID.
	 *
	 * @param int $chatbot_user_id Chatbot user ID.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_chatbot_user_id( $chatbot_user_id ): void {
		$this->chatbot_user_id = $chatbot_user_id;
	}
}