<?php

namespace Limb_Chatbot\Includes\Data_Objects;

/**
 * Class Chat_Meta
 *
 * Represents metadata for a chat.
 *
 * @package Limb_Chatbot\Includes\Data_Objects
 * @since 1.0.0
 */
class Chat_Meta extends Meta_Data_Object {

	/**
	 * Database table name.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_chat_metas';

	/**
	 * Fillable columns in the table.
	 *
	 * @var array
	 * @since 1.0.0
	 */
	const FILLABLE = [
		'chat_id',
		'meta_key',
		'meta_value',
	];

	/**
	 * ID of the chat this meta belongs to.
	 *
	 * @var int|null
	 * @since 1.0.0
	 */
	public ?int $chat_id;

	/**
	 * Get the chat ID.
	 *
	 * @return int|null Chat ID.
	 * @since 1.0.0
	 */
	public function get_chat_id() {
		return $this->chat_id;
	}

	/**
	 * Set the chat ID.
	 *
	 * @param  int|null  $chat_id  Chat ID.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_chat_id( $chat_id ): void {
		$this->chat_id = $chat_id;
	}
}
