<?php

namespace Limb_Chatbot\Includes\Data_Objects;


/**
 * Class AI_Model_Meta
 *
 * Represents meta data associated with an AI model.
 *
 * @package Limb_Chatbot\Includes\Data_Objects
 * @since 1.0.0
 */
class AI_Model_Meta extends Meta_Data_Object {

	/**
	 * Database table name.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	const TABLE_NAME = 'lbaic_ai_model_metas';

	/**
	 * Fillable fields for the meta object.
	 *
	 * @var array
	 * @since 1.0.0
	 */
	const FILLABLE = [ 'ai_model_id', 'meta_key', 'meta_value', ];

	/**
	 * Fine tuning status constants.
	 *
	 * @since 1.0.0
	 */
	const FINE_TUNING_STARTED = 1;
	const FINE_TUNING_PAUSED = 2;
	const FINE_TUNING_CANCELED = 3;
	const FINE_TUNING_COMPLETED = 4;
	const FINE_TUNING_FAILED = 0;

	/**
	 * AI model ID associated with this meta.
	 *
	 * @var int|null
	 * @since 1.0.0
	 */
	public ?int $ai_model_id = null;

	/**
	 * Get the AI model ID.
	 *
	 * @return int|null AI model ID or null if not set.
	 * @since 1.0.0
	 */
	public function get_ai_model_id(): ?int {
		return $this->ai_model_id;
	}

	/**
	 * Set the AI model ID.
	 *
	 * @param int|null $ai_model_id AI model ID to set.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_model_id( ?int $ai_model_id ): void {
		$this->ai_model_id = $ai_model_id;
	}
}