<?php

namespace Limb_Chatbot\Includes\Data_Objects;

use Limb_Chatbot\Includes\Services\Helper;

class Action_Submission extends WPDB_Data_Object {
	const TABLE_NAME = 'lbaic_action_submissions';

	const FILLABLE = [
		'id',
		'action_id',
		'action_data',
		'chatbot_user_id',
		'chat_uuid',
		'callback_results',
		'extracted_vars',
		'status',
		'error_message',
		'created_at',
	];

	const STATUS_PENDING = 'pending';
	const STATUS_SUCCESS = 'success';
	const STATUS_FAILED = 'failed';

	public ?int $action_id = null;
	public ?array $action_data = null;
	public ?int $chatbot_user_id = null;
	public ?string $chat_uuid = null;
	public ?string $status = self::STATUS_PENDING;
	public ?string $error_message = null;

	/**
	 * @json_excluded
	 * @var array|null
	 */
	public ?array $extracted_vars = null;
	public ?string $created_at = null;

	/**
	 * @json_excluded
	 * @var array|null
	 */
	public ?array $callback_results = null;

	public function __construct( $instance = null ) {
		if ( is_array( $instance ) ) {
			if ( ! empty( $instance['action_data'] ) && $this->isJson( $instance['action_data'] ) ) {
				$instance['action_data'] = Helper::maybe_json_decode( $instance['action_data'] );
			}
			if ( ! empty( $instance['callback_results'] ) && $this->isJson( $instance['callback_results'] ) ) {
				$instance['callback_results'] = Helper::maybe_json_decode( $instance['callback_results'] );
			}
			if ( ! empty( $instance['extracted_vars'] ) && $this->isJson( $instance['extracted_vars'] ) ) {
				$instance['extracted_vars'] = Helper::maybe_json_decode( $instance['extracted_vars'] );
			}
		}
		parent::__construct( $instance );
	}

	public function get_action_id(): ?int {
		return $this->action_id;
	}

	public function set_action_id( ?int $action_id ): void {
		$this->action_id = $action_id;
	}

	public function get_action_data(): ?array {
		return $this->action_data;
	}

	public function set_action_data( ?array $action_data ): void {
		$this->action_data = $action_data;
	}

	public function get_chatbot_user_id(): ?int {
		return $this->chatbot_user_id;
	}

	public function set_chatbot_user_id( ?int $chatbot_user_id ): void {
		$this->chatbot_user_id = $chatbot_user_id;
	}

	public function get_chat_uuid(): ?string {
		return $this->chat_uuid;
	}

	public function set_chat_uuid( ?string $chat_uuid ): void {
		$this->chat_uuid = $chat_uuid;
	}

	public function get_callback_results(): ?array {
		return $this->callback_results;
	}

	public function set_callback_results( ?array $callback_results ): void {
		$this->callback_results = $callback_results;
	}

	public function is_success() {
		return $this->get_status() !== self::STATUS_FAILED;
	}

	public function get_status(): ?string {
		return $this->status;
	}

	public function set_status( ?string $status ): void {
		$this->status = $status;
	}

	public function get_error_message(): ?string {
		return $this->error_message;
	}

	public function set_error_message( ?string $error_message ): void {
		$this->error_message = $error_message;
	}

	public function get_created_at(): ?string {
		return $this->created_at;
	}

	public function set_created_at( ?string $created_at ): void {
		$this->created_at = $created_at;
	}

	public function input( string $string ) {
		return ! empty( $this->action_data[ $string ] ) ? $this->action_data[ $string ] : null;
	}

	public function mark_as_success( ?array $callback_results = null ): void {
		$this->set_status( self::STATUS_SUCCESS );
	}

	public function mark_as_failed( string $error_message ): void {
		$this->set_status( self::STATUS_FAILED );
		$this->set_error_message( $error_message );
	}

	public function get_extracted_vars(): ?array {
		return $this->extracted_vars ?? [];
	}

	public function set_extracted_vars( ?array $extracted_vars ): void {
		$this->extracted_vars = $extracted_vars;
	}
}
