<?php

namespace Limb_Chatbot\Includes\Data_Objects;

class Action_Plan {

	public array $steps = [];

	public string $action_name;
	public ?string $chat_uuid = null;

	public function add_step( Action_Plan_Step $step ) {
		$this->steps[] = $step;
	}

	public function next_step() {
	}

	public function next_incomplete_step() {
		foreach ( $this->steps as $step ) {
			if ( ! $step instanceof Action_Plan_Step ) {
				continue;
			}
			if ( $step->get_state() === Action_Plan_Step::STATE_INCOMPLETE ) {
				return $step;
			}
		}

		return null;
	}

	public function action() {
		return Action::find_by_name( $this->get_action_name() );
	}

	public function get_action_name(): string {
		return $this->action_name;
	}

	public function set_action_name( string $action_name ): void {
		$this->action_name = $action_name;
	}

	public function get_previous_step() {
		foreach ( array_reverse( $this->steps ) as $plan_step ) {
			if ( $plan_step instanceof Action_Plan_Step && $plan_step->get_type() === Action_Plan_Step::TYPE_DATA_COLLECTION ) {
				$step_data = $plan_step->get_data();
				if ( $plan_step->get_state() === Action_Plan_Step::STATE_COMPLETE && isset( $step_data['parameter'], $step_data['value'] ) ) {
					$step_parameter = $step_data['parameter'];
					if ( $step_parameter instanceof Parameter ) {
						return [
							'field' => $step_parameter->get_label() ?? $step_parameter->get_name(),
							'value' => $step_data['value']
						];
					}
				}
			}
		}

		return null;
	}

	public function collected_fields() {
		$collected_fields = [];

		foreach ( $this->steps as $step ) {
			if ( ! $step instanceof Action_Plan_Step || $step->get_type() !== Action_Plan_Step::TYPE_DATA_COLLECTION ) {
				continue;
			}

			$data = $step->get_data();
			if ( ! isset( $data['parameter'], $data['value'] ) ) {
				continue;
			}

			$parameter = $data['parameter'];
			if ( $parameter instanceof Parameter ) {
				$collected_fields[ $parameter->get_name() ] = $data['value'];
			}
		}

		return $collected_fields;
	}

	public function get_parameters() {
		$result = [];
		foreach ( $this->steps as $step ) {
			if ( ! $step instanceof Action_Plan_Step || $step->get_type() !== Action_Plan_Step::TYPE_DATA_COLLECTION ) {
				continue;
			}

			$data = $step->get_data();
			if ( ! isset( $data['parameter'], $data['value'] ) ) {
				continue;
			}

			$parameter = $data['parameter'];
			if ( $parameter instanceof Parameter ) {
				$result[ $parameter->get_name() ] = $parameter;
			}
		}

		return $result;
	}

	public function get_first_step(): ?Action_Plan_Step {
		return $this->steps[0] ?? null;
	}

	public function set_chat_uuid( string $get_uuid ) {
		$this->chat_uuid = $get_uuid;
	}

	public function get_chat_uuid(): ?string {
		return $this->chat_uuid;
	}
}