<?php

namespace Limb_Chatbot\Includes\Data_Objects;

class Action_Plan_Step {

	const TYPE_DATA_COLLECTION = 1;
	const TYPE_SUBMISSION = 2;
	const TYPE_EMAIL_VERIFICATION = 3;
	const STATE_INCOMPLETE = 1;
	const STATE_COMPLETE = 2;

	public static $data_collection_fields = array(
		self::TYPE_DATA_COLLECTION,
		self::TYPE_EMAIL_VERIFICATION
	);

	public int $type;
	public array $data = [];
	public int $state;

	public function get_type(): int {
		return $this->type;
	}

	public function set_type( int $type ): void {
		$this->type = $type;
	}

	public function get_data() {
		return $this->data;
	}

	public function set_data( array $array ) {
		$this->data = $array;
	}

	public function add_data( $key, $value ) {
		$this->data[ $key ] = $value;
	}

	public function get_state() {
		return $this->state;
	}

	public function set_state( $state ) {
		$this->state = $state;
	}

	public function is_data_collect_step() {
		return in_array( $this->type, self::$data_collection_fields );
	}
}