<?php

namespace Limb_Chatbot\Includes\Data_Objects;

class Action_Callback_Result {
	public array $data = [];
	protected bool $success = true;
	protected string $message = '';

	public function success( string $message = '', array $data = [] ): self {
		return $this->set_success( true )->set_message( $message )->set_data( $data );
	}

	public function error( string $message = '', array $data = [] ): self {
		return $this->set_success( false )->set_message( $message )->set_data( $data );
	}

	public function to_array() {
		return [
			'success' => $this->is_success(),
			'message' => $this->get_message(),
			'data'    => $this->get_data(),
		];
	}

	public function is_success(): bool {
		return $this->success;
	}

	public function set_success( bool $success ): self {
		$this->success = $success;

		return $this;
	}

	public function get_message(): string {
		return $this->message;
	}

	public function set_message( string $message ): self {
		$this->message = $message;

		return $this;
	}

	public function get_data() {
		return $this->data;
	}

	public function set_data( array $data ): self {
		$this->data = $data;

		return $this;
	}
}
