<?php

namespace Limb_Chatbot\Includes;

use Limb_Chatbot\Includes\Admin\Admin;
use Limb_Chatbot\Includes\AI_Providers\AI_Providers;
use Limb_Chatbot\Includes\Api\Server;
use Limb_Chatbot\Includes\Cpts\Custom_Post_Types;
use Limb_Chatbot\Includes\Frontend\Frontend;
use Limb_Chatbot\Includes\Services\Install;
use Limb_Chatbot\Includes\Services\Notifications\Notification_Bootstrap;
use Limb_Chatbot\Includes\Services\Session_Manager;
use Limb_Chatbot\Includes\Services\User_Manager;

final class Limb_Chatbot {

	/**
	 * Singleton instance of the plugin.
	 *
	 * @since 1.0.0
	 * @var self|null
	 */
	private static ?self $_instance = null;

	/**
	 * Whether debug mode is enabled.
	 *
	 * @since 1.0.0
	 * @var bool
	 */
	private bool $debug;

	/**
	 * Registered plugin integrations.
	 *
	 * @since 1.0.0
	 * @var array
	 */
	protected array $integrations = [];

	/**
	 * Plugin slug name.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	private string $plugin_name;

	/**
	 * Absolute plugin directory path.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	private string $plugin_dir_path;

	/**
	 * Relative path to the plugin files directory.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	private string $files_dir;

	/**
	 * Absolute plugin directory URL.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	private string $plugin_dir_url;

	/**
	 * Plugin prefix for settings and filters.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	private string $plugin_prefix;

	/**
	 * Plugin version.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	private string $version;

	/**
	 * Session manager instance.
	 *
	 * @since 1.0.0
	 * @var Session_Manager|null
	 */
	public ?Session_Manager $session_manager;

	/**
	 * User manager instance.
	 *
	 * @since 1.0.0
	 * @var User_Manager|null
	 */
	public ?User_Manager $user_manager;

	/**
	 * Plugin constructor.
	 *
	 * @since 1.0.0
	 */
	private function __construct() {
		$this->version         = defined( 'LIMB_CHATBOT_VERSION' ) ? LIMB_CHATBOT_VERSION : '1.0.15';
		$this->debug           = get_option( 'lbaic.settings.debug', false );
		$this->plugin_name     = 'limb-chatbot';
		$this->plugin_prefix   = 'lbaic';
		$this->files_dir       = 'lbaic/files/';
		$this->plugin_dir_path = plugin_dir_path( dirname( __FILE__ ) );
		$this->plugin_dir_url  = plugin_dir_url( dirname( __FILE__ ) );
		$this->load_dependencies();
	}

	/**
	 * Load required plugin classes, traits and interfaces
	 *
	 * @since 1.0.0
	 */
	private function load_dependencies(): void {
		/**
		 * Traits
		 */
		require_once $this->plugin_dir_path . 'includes/traits/class-lbaic-singleton-trait.php';
		require_once $this->plugin_dir_path . 'includes/traits/class-lbaic-json-serializable-trait.php';
		require_once $this->plugin_dir_path . 'includes/traits/class-lbaic-encryptable-trait.php';
		/**
		 * Interfaces
		 */
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-database-strategy-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-config-dependant-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-endpoint-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-utility-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-response-handler-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-scheme-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-fine-tuning-file-formatting-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-usage-service-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-token-calculator-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-chatbot-parameter-parser-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-vector-searcher-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-file-reader-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-knowledge-mapper-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-source-fetcher-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-system-message-generator-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-knowledge-generator-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-file-upload-capable-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-action-callback-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-action-callback-executor-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-parameter-type-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-data-accessible-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-data-collecting-processor-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-source-validator-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-parameter-type-schema-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-dataset-builder-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-parameter-callback-handler-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-migration-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-live-agent-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-job-handler-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-multitask-handler-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-task-processor-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-chunk-stringifier-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-recommendation-search-processor-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-notification-channel-interface.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-notification-type-interface.php';
		/**
		 * Libraries
		 */
		require_once $this->plugin_dir_path . 'includes/lib/action-scheduler/action-scheduler.php';
		// PDFParser library is loaded lazily when needed to avoid conflicts with other plugins
		/**
		 * Factories
		 */
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-chatbot-service-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-chat-service-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-database-strategy-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-message-service-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-fine-tuning-file-formatter-service-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-usage-service-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-token-calculator-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-chatbot-parameter-parser-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-limit-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-widget-item-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-file-reader-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-knowledge-mapper-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-source-fetcher-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-knowledge-generator-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-action-callback-executor-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-data-collecting-processor-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-parameter-type-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-source-validator-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-dataset-builder-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-live-agent-service-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-parameter-callback-handler-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-wp-object-repository-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-job-handler-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-task-processor-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-recommendation-search-processor-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-entry-stringifier-factory.php';
		require_once $this->plugin_dir_path . 'includes/factories/class-lbaic-chatbot-analytics-factory.php';
		/**
		 * Repositories
		 */
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-chat-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-chat-meta-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-vector-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-vector-index-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-chatbot-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-chatbot-meta-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-setting-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-message-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-ai-model-meta-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-ai-model-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-dataset-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-dataset-entry-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-dataset-meta-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-config-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-chatbot-user-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-widget-item-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-conversation-state-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-file-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-action-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-parameter-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-action-callback-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-wp-object-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-wp-object-group-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-wp-archive-object-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-wp-post-object-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-wp-term-object-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-wp-special-page-object-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-job-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-job-task-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-lead-field-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-lead-repository.php';
		require_once $this->plugin_dir_path . 'includes/repositories/class-lbaic-action-submission-repository.php';
		/**
		 * DB strategies
		 */
		require_once $this->plugin_dir_path . 'includes/database-strategies/class-lbaic-database-strategy.php';
		require_once $this->plugin_dir_path . 'includes/database-strategies/class-lbaic-wp-options.php';
		require_once $this->plugin_dir_path . 'includes/database-strategies/class-lbaic-wp-query.php';
		require_once $this->plugin_dir_path . 'includes/database-strategies/class-lbaic-wp-meta-query.php';
		require_once $this->plugin_dir_path . 'includes/database-strategies/class-lbaic-wpdb.php';
		/**
		 * Data objects
		 */
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-data-object.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wpdb-data-object.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-post-data-object.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-meta-data-object.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-meta-data-object.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-message.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-embeddable-message.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-message-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chatbot.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chatbot-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chat.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chat-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-vector.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-vector-index.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-vector-index-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-vector-index-vector.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-config.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-setting.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-dataset.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-dataset-entry.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-dataset-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-ai-model-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-ai-model.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chatbot-tool.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-tool-result-message.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-ai-model-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-limit.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-token-usage.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chatbot-user.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chatbot-user-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chatbot-limit.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-user-limit.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-guest-limit.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-input-limit.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-output-limit.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-chat-participant.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-segment.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-conversation-state.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-file.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-parameter.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action-callback-result.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action-submission.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action-plan-step.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action-plan.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-action-callback.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-object-group.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-archive-object-group.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-object.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-post-object-group.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-term-object-group.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-wp-special-page-object-group.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-job.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-job-task.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-lead-capture.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-lead.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-lead-field.php';
		require_once $this->plugin_dir_path . 'includes/data-objects/class-lbaic-lead-value.php';
		/**
		 * Data schemas
		 */
		require_once $this->plugin_dir_path . 'includes/data-schemas/class-lbaic-setting.php';
		require_once $this->plugin_dir_path . 'includes/data-schemas/class-lbaic-chatbot-meta.php';
		require_once $this->plugin_dir_path . 'includes/data-schemas/class-lbaic-dataset-csv-file.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/data-schemas/class-lbaic-setting.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/data-schemas/class-lbaic-setting.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/data-schemas/class-lbaic-setting.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/data-schemas/class-lbaic-setting.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/data-schemas/class-lbaic-setting.php';
		/**
		 * Migrations
		 */
		require_once $this->plugin_dir_path . 'includes/migrations/class-lbaic-abstract-migration.php';
		/**
		 * Services
		 */
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-install.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-migration-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-data-deletion-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-sanitizer.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-seeder-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-collection.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chat-context.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-data-object-collection.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-file-upload-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-file-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-live-agent-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-widget-collection.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-widget-item-collection.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-helper.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-event-stream-curl.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-user-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-session-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-csv-file-reader.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chatbot-parameter-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chatbot-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-vector-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-vector-index-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chat-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-message-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-context-provider-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-vector-db-searcher.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-ai-model-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-config-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chat-language-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-usage-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chatbot-usage-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-user-usage-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-input-usage-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chatbot-limits-parser.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chatbot-widgets-parser.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-fine-tuning-file-formatting-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-dataset-csv-file-parser.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-dataset-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-dataset-entry-service.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/data/class-lbaic-analytics-data.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/data/class-lbaic-analytics-data-point.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/types/class-lbaic-analytics-type.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/types/class-lbaic-action-analytics-type.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/types/class-lbaic-analytics-type-registry.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/types/class-lbaic-builtin-analytics-type.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-analytics-calculator.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-calculator-registry.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-conversations-calculator.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-new-visitors-calculator.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-returning-visitors-calculator.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-leads-captured-calculator.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-action-submissions-calculator.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/calculators/class-lbaic-period-bucketing.php';
		require_once $this->plugin_dir_path . 'includes/services/chatbot-analytics/class-lbaic-chatbot-analytics-service.php';
		require_once $this->plugin_dir_path . 'includes/services/automations/class-lbaic-post-creation-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/automations/class-lbaic-post-update-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/automations/class-lbaic-post-deletion-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-user-prompt-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-semantic-segmenter.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-conversation-state-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-conversation-state-analyzer.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-chatbot-profile-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-post-types-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-wp-object-by-identifier-service.php';
		require_once $this->plugin_dir_path . 'includes/services/class-lbaic-stream-event-service.php';
		require_once $this->plugin_dir_path . 'includes/services/parsers/class-lbaic-action-plan-parser.php';
		require_once $this->plugin_dir_path . 'includes/services/system-message/class-lbaic-system-message-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/system-message/class-lbaic-chatbot-system-message-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/system-message/generators/class-lbaic-chatbot-system-message.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/class-lbaic-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/class-lbaic-indexing-service.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/class-lbaic-knowledge-source-store.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/class-lbaic-knowledge-source-tracker.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/dataset-builders/class-lbaic-actionable-dataset-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/dataset-builders/class-lbaic-informational-dataset-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-validators/class-lbaic-manual-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-validators/class-lbaic-file-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-validators/class-lbaic-posts-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-validators/class-lbaic-text-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-validators/class-lbaic-cpt-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-validators/class-lbaic-url-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/generators/class-lbaic-manual-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/generators/class-lbaic-post-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/generators/class-lbaic-file-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/generators/class-lbaic-text-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/generators/class-lbaic-cpt-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/generators/class-lbaic-url-knowledge-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/content-extractors/class-lbaic-content-extractor.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/content-extractors/class-lbaic-pdf-content-extractor.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/content-extractors/class-lbaic-url-content-extractor.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/chunkers/class-lbaic-heading-aware-chunker.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/chunkers/utilities/class-lbaic-token-estimator.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/builders/class-lbaic-chunk-entry-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/stringifiers/class-lbaic-chunk-stringifier.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/stringifiers/class-lbaic-qa-stringifier.php';
		require_once $this->plugin_dir_path . 'includes/interfaces/class-lbaic-chunk-stringifier-interface.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-manual-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-post-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-term-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-file-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-text-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-cpt-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/knowledge-mappers/class-lbaic-url-knowledge-mapper.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-manual-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-posts-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-terms-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-file-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-text-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-cpt-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/knowledge/source-object-fetchers/class-lbaic-url-source-fetcher.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-submission-service.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-service.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-parameter-service.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-plan-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-parameter-type-registry.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-parameter-value-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-parameter-value-result.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-validation-error-message-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-callback-chain-executor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-callback-execution-context.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-variable-replacer.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-executor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-email-verification-service.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-email-verification-message-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-envelope.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-type-registry.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-channel-registry.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-role-resolver.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-log-repository.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-service.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/types/class-lbaic-abstract-notification-type.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/types/class-lbaic-chat-created-notification-type.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/types/class-lbaic-lead-captured-notification-type.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/channels/class-lbaic-email-notification-channel.php';
		require_once $this->plugin_dir_path . 'includes/services/notifications/class-lbaic-notification-bootstrap.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-parameter-request-message-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-search-results-provider.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-vector-search-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-callback-service.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-lead-capture-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/data-collecting-processors/class-lbaic-data-collecting-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/data-collecting-processors/class-lbaic-standard-data-collecting-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/data-collecting-processors/class-lbaic-post-data-collecting-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/class-lbaic-action-submission-message-builder.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/executors/class-lbaic-abstract-callback-executor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/executors/class-lbaic-email-callback-executor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/executors/class-lbaic-slack-callback-executor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/executors/class-lbaic-callback-executor-response.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/validators/class-lbaic-parameter-validator.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-abstract-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-email-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-text-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-url-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-buttons-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-textarea-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/parameter-types/class-lbaic-vector-search-parameter-type.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/recommendation-search-processors/class-lbaic-vector-search-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/actions/recommendation-search-processors/class-lbaic-wp-search-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/class-lbaic-job-service.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/class-lbaic-job-stats-service.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/class-lbaic-job-task-generator.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/class-lbaic-job-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/managers/class-lbaic-job-lock-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/managers/class-lbaic-job-processing-limits.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/managers/class-lbaic-job-error-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/managers/class-lbaic-job-state-manager.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/processors/class-lbaic-child-task-generation-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/processors/class-lbaic-standard-task-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/processors/class-lbaic-child-task-processor.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-abstract-job-handler.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-dataset-generating.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-dataset-delete.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-dataset-sync.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-dataset-regenerate.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-file-upload.php';
		require_once $this->plugin_dir_path . 'includes/services/jobs/handlers/class-lbaic-sitemap-scrape.php';
		/**
		 * Slack integration
		 */
		require_once $this->plugin_dir_path . 'includes/integrations/slack/class-lbaic-slack.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/services/class-lbaic-slack-validation-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/services/class-lbaic-slack-agent-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/services/class-lbaic-slack-live-agent-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/services/class-lbaic-slack-event-handler-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/services/class-lbaic-slack-message-sync-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/services/class-lbaic-slack-bot-message-builder.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/class-lbaic-slack-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/channels/class-lbaic-channels-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/channels/class-lbaic-channels-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/users/class-lbaic-users-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/users/class-lbaic-users-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/messages/class-lbaic-messages-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/endpoints/messages/class-lbaic-messages-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/utilities/class-lbaic-channels-utility.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/utilities/class-lbaic-users-utility.php';
		require_once $this->plugin_dir_path . 'includes/integrations/slack/utilities/class-lbaic-messages-utility.php';
		/**
		 * Telegram integration
		 */
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/class-lbaic-telegram.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/endpoints/class-lbaic-telegram-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/endpoints/users/class-lbaic-users-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/endpoints/users/class-lbaic-users-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/endpoints/webhook/class-lbaic-webhook-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/utilities/class-lbaic-users-utility.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/endpoints/messages/class-lbaic-messages-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/endpoints/messages/class-lbaic-messages-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/utilities/class-lbaic-messages-utility.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/utilities/class-lbaic-webhook-utility.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-live-agent-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-message-sync-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-event-handler-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-webhook-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-agent-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-validation-service.php';
		require_once $this->plugin_dir_path . 'includes/integrations/telegram/services/class-lbaic-telegram-bot-message-builder.php';
		/**
		 * Rest Api
		 */
		require_once $this->plugin_dir_path . 'includes/api/class-lbaic-server.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-rest-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chatbot-metas-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chat-messages-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-vectors-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-vector-indexes-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-configs-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-settings-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-datasets-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-dataset-entries-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-dataset-metas-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chats-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-ai-models-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chatbots-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-ai-model-metas-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-vector-index-metas-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-files-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chat-metas-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-plugin-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-post-types-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-actions-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-parameters-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-action-callbacks-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-live-agent-messages-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-jobs-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-widgets-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chatbot-analytics-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-action-submissions-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-leads-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-lead-fields-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/class-lbaic-chatbot-users-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/integrations/class-lbaic-slack-controller.php';
		require_once $this->plugin_dir_path . 'includes/api/v1/controllers/integrations/class-lbaic-telegram-controller.php';
		/**
		 * Custom post types
		 */
		require_once $this->plugin_dir_path . 'includes/cpts/class-lbaic-custom-post-types.php';
		/**
		 * Exceptions
		 */
		require_once $this->plugin_dir_path . 'includes/exceptions/class-lbaic-exception.php';
		require_once $this->plugin_dir_path . 'includes/exceptions/class-lbaic-error-codes.php';
		/**
		 * Vector DBs
		 */
		require_once $this->plugin_dir_path . 'includes/vector-dbs/class-lbaic-vector-db.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/local/class-lbaic-local.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/local/utilities/class-lbaic-vector-db.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/class-lbaic-pinecone.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/services/class-lbaic-auth-service.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/index/class-lbaic-index-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/index/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/query/class-lbaic-query-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/query/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/vectors/class-lbaic-vectors-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/endpoints/vectors/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/vector-dbs/pinecone/utilities/class-lbaic-vector-db.php';
		/**
		 * Ai Providers
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/class-lbaic-ai-providers.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/class-lbaic-ai-provider.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/class-lbaic-open-ai.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/class-lbaic-gemini.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/class-lbaic-deep-seek.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/class-lbaic-claude.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/class-lbaic-grok.php';
		/**
		 * Open ai services
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/services/class-lbaic-fine-tuning-file-format-service.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/services/class-lbaic-token-calculator.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/services/class-lbaic-message-service.php';
		/**
		 * Gemini services
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/services/class-lbaic-token-calculator.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/services/class-lbaic-message-service.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/services/class-lbaic-google-oauth-service.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/services/class-lbaic-ai-model-cost-service.php';
		/**
		 * Deep Seek services
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/services/class-lbaic-token-calculator.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/services/class-lbaic-ai-model-cost-service.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/services/class-lbaic-message-service.php';
		/**
		 * Claude services
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/services/class-lbaic-token-calculator.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/services/class-lbaic-message-service.php';
		/**
		 * Grok services
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/services/class-lbaic-token-calculator.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/services/class-lbaic-message-service.php';
		/**
		 * Open ai interfaces
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/interfaces/class-lbaic-required-actions-interface.php';
		/**
		 * Ai Provider factories
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/factories/class-lbaic-assistant-required-action-factory.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/factories/class-lbaic-submit-tools-output-factory.php';
		/**
		 * Ai Provider Endpoints
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/model/class-lbaic-model-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/chat-completion/class-lbaic-chat-completion-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/chat-completion/class-lbaic-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/chat-completion/class-lbaic-tool-result-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/chat-completion/class-lbaic-stream-parser.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/embedding/class-lbaic-embedding-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/fine-tuning/class-lbaic-fine-tuning-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/vector-store/class-lbaic-vector-store-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/file/class-lbaic-file-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/assistant/required-actions/class-lbaic-submit-tools-output.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/assistant/tools/class-lbaic-function-calling.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/assistant/class-lbaic-assistant-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/response/class-lbaic-response-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/model/class-lbaic-model-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/generate-content/class-lbaic-generate-content-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/generate-content/class-lbaic-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/generate-content/class-lbaic-tool-result-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/generate-content/class-lbaic-stream-parser.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/embed-content/class-lbaic-embed-content-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/token/class-lbaic-token-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/file/class-lbaic-file-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/chat-completion/class-lbaic-chat-completion-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/chat-completion/class-lbaic-stream-parser.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/chat-completion/class-lbaic-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/chat-completion/class-lbaic-tool-result-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/model/class-lbaic-model-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/chat-completion/class-lbaic-chat-completion-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/model/class-lbaic-model-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/chat-completion/class-lbaic-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/chat-completion/class-lbaic-tool-result-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/class-lbaic-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/chat-completion/class-lbaic-chat-completion-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/model/class-lbaic-model-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/chat-completion/class-lbaic-tool-calls-message.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/chat-completion/class-lbaic-tool-result-message.php';
		/**
		 * Handlers
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/model/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/chat-completion/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/embedding/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/fine-tuning/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/file/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/endpoints/response/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/generate-content/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/embed-content/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/model/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/endpoints/file/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/chat-completion/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/endpoints/model/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/chat-completion/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/chat-completion/class-lbaic-stream-parser.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/model/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/file/class-lbaic-file-endpoint.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/endpoints/file/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/handlers/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/chat-completion/class-lbaic-response-handler.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/chat-completion/class-lbaic-stream-parser.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/endpoints/model/class-lbaic-response-handler.php';
		/**
		 * Admin
		 */
		require_once $this->plugin_dir_path . 'includes/admin/class-lbaic-ajax.php';
		require_once $this->plugin_dir_path . 'includes/admin/class-lbaic-admin-assets.php';
		require_once $this->plugin_dir_path . 'includes/admin/class-lbaic-admin.php';
		require_once $this->plugin_dir_path . 'includes/admin/pages/default-chatbot/class-lbaic-page.php';
		require_once $this->plugin_dir_path . 'includes/admin/pages/setting/class-lbaic-page.php';
		require_once $this->plugin_dir_path . 'includes/admin/pages/leads/class-lbaic-page.php';
		require_once $this->plugin_dir_path . 'includes/admin/pages/actions/class-lbaic-page.php';
		require_once $this->plugin_dir_path . 'includes/admin/pages/notifications/class-lbaic-page.php';
		/**
		 * Frontend
		 */
		require_once $this->plugin_dir_path . 'includes/frontend/class-lbaic-frontend.php';
		require_once $this->plugin_dir_path . 'includes/frontend/class-lbaic-page-context.php';
		/**
		 * Utilities
		 */
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-fine-tuning-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-file-upload-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-embedding-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-vector-db-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-ai-model-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-copilot-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-slack-channels-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-slack-users-utility.php';
		require_once $this->plugin_dir_path . 'includes/utilities/class-lbaic-slack-messages-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-fine-tuning-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-fine-tuning-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-file-upload-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-embedding-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-vector-store-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-assistant-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-ai-model-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/utilities/class-lbaic-copilot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/utilities/class-lbaic-embedding-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/utilities/class-lbaic-copilot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/utilities/class-lbaic-token-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/utilities/class-lbaic-ai-model-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/utilities/class-lbaic-file-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/utilities/class-lbaic-ai-model-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/utilities/class-lbaic-copilot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/utilities/class-lbaic-ai-model-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/utilities/class-lbaic-copilot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/utilities/class-lbaic-file-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/utilities/class-lbaic-chatbot-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/utilities/class-lbaic-ai-model-utility.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/utilities/class-lbaic-copilot-utility.php';
		/**
		 * Widgets
		 */
		require_once $this->plugin_dir_path . 'includes/widgets/class-lbaic-widget.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-widget-items.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-widget-item.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-chat-history-widget-item.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-link-widget-item.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-message-widget-item.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-prompt-widget-item.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-text-widget-item.php';
		require_once $this->plugin_dir_path . 'includes/widgets/items/class-lbaic-lead-capture-widget-item.php';

		/**
		 * Widget Callbacks
		 */
		require_once $this->plugin_dir_path . 'includes/widgets/callbacks/class-lbaic-widget-callback-interface.php';
		require_once $this->plugin_dir_path . 'includes/widgets/callbacks/class-lbaic-widget-callback-factory.php';
		require_once $this->plugin_dir_path . 'includes/widgets/callbacks/class-lbaic-lead-capture-callback.php';
		/**
		 * Seeders
		 */
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/seeders/class-lbaic-ai-models-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/open-ai/seeders/class-lbaic-settings-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/seeders/class-lbaic-ai-models-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/deep-seek/seeders/class-lbaic-settings-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/seeders/class-lbaic-ai-models-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/gemini/seeders/class-lbaic-settings-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/claude/seeders/class-lbaic-ai-models-seeder.php';
		require_once $this->plugin_dir_path . 'includes/ai-providers/grok/seeders/class-lbaic-ai-models-seeder.php';
		/**
		 * Chatbot tools
		 */
		require_once $this->plugin_dir_path . 'includes/chatbot-tools/seeders/class-lbaic-actions-seeder.php';
		require_once $this->plugin_dir_path . 'includes/chatbot-tools/class-lbaic-chatbot-tool.php';
		require_once $this->plugin_dir_path . 'includes/chatbot-tools/class-lbaic-chatbot-tools.php';
		require_once $this->plugin_dir_path . 'includes/chatbot-tools/tools/class-lbaic-knowledge-search.php';
		require_once $this->plugin_dir_path . 'includes/chatbot-tools/tools/class-lbaic-live-agent-connection.php';
		require_once $this->plugin_dir_path . 'includes/chatbot-tools/actions/class-lbaic-action-chatbot-tool.php';
	}

	/**
	 * Register custom post types.
	 *
	 * @since 1.0.0
	 */
	public function register_cpts(): void {
		Custom_Post_Types::setup();
	}

	/**
	 * Register Gutenberg blocks.
	 *
	 * @since 1.0.0
	 */
	public function register_blocks(): void {
	}

	/**
	 * Define and initialize admin-related classes.
	 *
	 * @since 1.0.0
	 */
	private function define_admin_classes(): void {
		Admin::instance()->boot();
	}

	/**
	 * Initialize frontend logic and hooks.
	 *
	 * @since 1.0.0
	 */
	private function frontend(): void {
		Frontend::instance()->init();
	}

	/**
	 * Register plugin activation and deactivation hooks.
	 *
	 * @since 1.0.0
	 */
	private function init_activation_hooks(): void {
		register_activation_hook( LIMB_CHATBOT_FILE, array( Install::class, 'activate' ) );
		register_deactivation_hook( LIMB_CHATBOT_FILE, array( Install::class, 'deactivate' ) );
	}

	/**
	 * Get singleton instance of the plugin.
	 *
	 * @since 1.0.0
	 * @return self
	 */
	public static function get_instance(): self {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Get plugin prefix for internal identifiers.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_plugin_prefix(): string {
		return $this->plugin_prefix;
	}

	/**
	 * Initialize API server.
	 *
	 * @since 1.0.0
	 */
	private function api_init(): void {
		Server::get_instance()->init();
	}

	/**
	 * Initialize the notification system (types, channels, Action Scheduler handler).
	 *
	 * @since 1.0.15
	 */
	private function notifications_init(): void {
		Notification_Bootstrap::init();
	}

	/**
	 * Check if debug mode is enabled.
	 *
	 * @since 1.0.0
	 * @return bool
	 */
	public function get_debug(): bool {
		return $this->debug;
	}

	/**
	 * Run the plugin bootstrapping logic.
	 *
	 * @since 1.0.0
	 */
	public function run(): void {
		$this->register_cpts();
		$this->register_blocks();
		$this->init_activation_hooks();
		$this->define_admin_classes();
		$this->frontend();
		$this->set_session_manager( Session_Manager::instance() );
		$this->set_user_manager( User_Manager::instance() );
		$this->notifications_init();
		$this->api_init();
		$this->ai_providers_init();
	}

	/**
	 * Get the plugin name.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_plugin_name(): string {
		return $this->plugin_name;
	}

	/**
	 * Get the plugin version.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_version(): string {
		return $this->version;
	}

	/**
	 * Get the plugin directory path.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_plugin_dir_path(): string {
		return $this->plugin_dir_path;
	}

	/**
	 * Get the plugin file storage directory path.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_files_dir(): string {
		return $this->files_dir;
	}

	/**
	 * Get the plugin base URL.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_plugin_dir_url(): string {
		return $this->plugin_dir_url;
	}

	/**
	 * Get the session manager instance.
	 *
	 * @since 1.0.0
	 * @return Session_Manager|null
	 */
	public function get_session_manager(): ?Session_Manager {
		return $this->session_manager;
	}

	/**
	 * Set the session manager instance.
	 *
	 * @since 1.0.0
	 * @param Session_Manager $session_manager The session manager to assign.
	 */
	private function set_session_manager( Session_Manager $session_manager ): void {
		$this->session_manager = $session_manager;
	}

	/**
	 * Set the user manager instance.
	 *
	 * @since 1.0.0
	 * @param User_Manager $user_manager The user manager to assign.
	 */
	private function set_user_manager( User_Manager $user_manager ): void {
		$this->user_manager = $user_manager;
	}

	/**
	 * Initialize all AI providers.
	 *
	 * @since 1.0.0
	 */
	private function ai_providers_init(): void {
		AI_Providers::instance()->init();
	}
}
