<?php

namespace Limb_Chatbot\Includes\Chatbot_Tools\Seeders;

use Limb_Chatbot\Includes\Data_Objects\Action;
use Limb_Chatbot\Includes\Data_Objects\Action_Callback;
use Limb_Chatbot\Includes\Data_Objects\Chatbot;
use Limb_Chatbot\Includes\Data_Objects\Parameter;

class Actions_Seeder {
	public function seed() {
		do_action( 'lbaic_chatbot_before_actions_seed' );
		$this->seed_contact_action();
		do_action( 'lbaic_chatbot_after_actions_seed' );
	}

	public function seed_contact_action() {
		// 1. Create Action
		$action = Action::find_by_name( 'contact_us' );
		if ( ! $action ) {
			$action = new Action();
			$action->set_title( 'Contact Us' );
			$action->set_name( 'contact_us' );
			$action->set_ai_instructions(
				'Use this action whenever a user requests to contact the website administrator or needs to report an issue. When appropriate, proactively suggest this action to the user (e.g., "If you\'d like, I can help you get in touch with our team").'
			);
			$action->set_created_at( current_time( 'mysql', true ) );
			$action->set_updated_at( current_time( 'mysql', true ) );
			$action->save();
		}

		// 2. Create Parameters
		$params = [
			[
				'name'        => 'email',
				'label'       => 'Email Address',
				'type'        => 'email',
				'required'    => '1',
				'placeholder' => 'your@email.com',
			],
			[
				'name'        => 'full_name',
				'label'       => 'Full Name',
				'type'        => 'text',
				'required'    => '1',
				'placeholder' => 'John Doe',
			],
			[
				'name'        => 'message',
				'label'       => 'Message',
				'type'        => 'textarea',
				'required'    => '1',
				'placeholder' => 'Your message here...',
			],
		];

		foreach ( $params as $param_data ) {
			$existing = Parameter::where( [
				'action_id' => $action->get_id(),
				'name'      => $param_data['name'],
			] )->first();

			if ( ! $existing ) {
				$param = new Parameter();
				$param->set_action_id( $action->get_id() );
				$param->set_name( $param_data['name'] );
				$param->set_label( $param_data['label'] );
				$param->set_type( $param_data['type'] );
				$param->set_required( $param_data['required'] );
				$param->set_placeholder( $param_data['placeholder'] );
				$param->save();
			}
		}

		// 3. Create Email Callback
		$email_callback = Action_Callback::where( [
			'action_id' => $action->get_id(),
			'name'      => 'send_contact_email'
		] )->first();

		if ( ! $email_callback ) {
			$email_callback = new Action_Callback();
			$email_callback->set_action_id( $action->get_id() );
			$email_callback->set_name( 'send_contact_email' );
			$email_callback->set_title( 'Send Contact Email' );
			$email_callback->set_description( 'Sends the contact request to the website administrator via email' );
			$email_callback->set_type( Action_Callback::TYPE_EMAIL );
			$email_callback->set_order( 1 );
			$email_callback->set_is_required( 1 );
			$admin_email = get_option( 'admin_email' );
			$email_callback->set_config( [
				'to'        => $admin_email,
				'from'      => '{email}',
				'from_name' => '{full_name}',
				'subject'   => 'New Message – Contact Us Action',
				'body_html' => '',
				'body_text' => "You have received a new message from the Limb Chatbot – Contact Us action.\n\nSender Name: {full_name}\nSender Email: {email}\n\nMessage:\n{message}\n\n---\n\n\n\nThis message was generated via the Limb Chatbot WordPress plugin.",
			] );
			$email_callback->set_status( Action_Callback::STATUS_ACTIVE );
			$email_callback->save();
		}

		return true;
	}
}