<?php

namespace Limb_Chatbot\Includes\Chatbot_Tools\Actions;

use Limb_Chatbot\Includes\Chatbot_Tools\Chatbot_Tool;
use Limb_Chatbot\Includes\Data_Objects\Action;
use Limb_Chatbot\Includes\Data_Objects\Tool_Calls_Message;
use Limb_Chatbot\Includes\Utilities\Chatbot_Utility;

class Action_Chatbot_Tool extends Chatbot_Tool {

	public Action $action;

	public function __construct( Action $action ) {
		$this->action = $action;
		parent::__construct();
	}

	public function execute( array $params, Tool_Calls_Message $message, Chatbot_Utility $utility ): array {
		return array();
	}

	protected function define_name(): string {
		return $this->action->get_name();
	}

	protected function define_description(): string {
		return $this->action->get_ai_instructions();
	}

	protected function define_parameters_schema(): array {
		$properties         = [];
		$required_fields    = [];
		$properties['init'] = [
			'type'        => 'boolean',
			'description' => 'Always set this to true automatically when this action is triggered. Do not request it from user.',
			'default'     => true,
		];

		return [
			'type'       => 'object',
			'properties' => $properties,
			'required'   => $required_fields,
		];
	}
}