<?php

namespace Limb_Chatbot\Includes\Blocks;


/**
 * Chatbot block class.
 *
 * Handles registration of the Chatbot block and its assets.
 *
 * @since 1.0.0
 */
class Chatbot extends Block {

	/**
	 * Registers the Chatbot block using metadata from the `block.json` file.
	 *
	 * This method also registers all necessary assets to be enqueued in the block editor
	 * context automatically.
	 *
	 * @static
	 * @return void
	 * @since 1.0.0
	 */
	public function register() {
		register_block_type( Limb_Chatbot()->get_plugin_dir_path() . 'blocks/chatbot/build' );
	}
}
