<?php

namespace Limb_Chatbot\Includes\Blocks;


/**
 * Abstract base class for blocks.
 *
 * Provides an interface for registering blocks.
 *
 * @since 1.0.0
 */
abstract class Block {

	/**
	 * Registers the block.
	 *
	 * This method must be implemented by subclasses to register the block.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	abstract public function register();
}
