<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Seeders;

use Exception;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Open_Ai;

/**
 * Class AI_Models_Seeder
 *
 * Seeder class responsible for seeding AI models specific to the Open_Ai AI provider.
 * Creates or updates AI models with predefined configurations and metadata.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai\Seeders
 * @since 1.0.0
 */
class AI_Models_Seeder {

	/**
	 * Run the seeder to create or update AI models.
	 *
	 * Iterates over a predefined list of models, creates new entries if not present,
	 * or updates existing ones. Also updates associated metadata for each model.
	 *
	 * @return void
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function run() {
		$models = array(
			array(
				'label'              => 'GPT-5 Mini',
				'name'               => 'gpt-5-mini',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => false,
					'function_calling'   => true,
					'fine_tuning'        => false,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'output_token_cost' => 0.000002,
					'input_token_cost'  => 0.00000025,
				)
			),
			array(
				'label'              => 'GPT-5 Nano',
				'name'               => 'gpt-5-nano',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => false,
					'function_calling'   => true,
					'fine_tuning'        => false,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'output_token_cost' => 0.0000004,
					'input_token_cost'  => 0.00000005,
				)
			),
			array(
				'label'              => 'GPT-4.1',
				'name'               => 'gpt-4.1',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => true,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => true,
					'function_calling'   => true,
					'fine_tuning'        => true,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'output_token_cost' => 0.000008,
					'input_token_cost'  => 0.000002,
				)
			),
			array(
				'label'              => 'GPT-4.1 Mini',
				'name'               => 'gpt-4.1-mini',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => true,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => false,
					'function_calling'   => true,
					'fine_tuning'        => true,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'output_token_cost' => 0.0000016,
					'input_token_cost'  => 0.0000004,
				)
			),
			array(
				'label'              => 'GPT-4.1 Nano',
				'name'               => 'gpt-4.1-nano',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => true,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => false,
					'function_calling'   => true,
					'fine_tuning'        => true,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'output_token_cost' => 0.0000004,
					'input_token_cost'  => 0.0000001,
				)
			),
			array(
				'label'              => 'GPT-4o',
				'name'               => 'gpt-4o',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => true,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => true,
					'function_calling'   => true,
					'fine_tuning'        => true,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'output_token_cost' => 0.00001,
					'input_token_cost'  => 0.0000025,
				)
			),
			array(
				'label'              => 'GPT-4o Mini',
				'name'               => 'gpt-4o-mini',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 16384,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => true,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => false,
					'function_calling'   => true,
					'fine_tuning'        => true,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'input_token_cost'  => 0.0000015,
					'output_token_cost' => 0.000006,
				)
			),
			array(
				'label'              => 'GPT-4 Turbo',
				'name'               => 'gpt-4-turbo',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 4096,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => true,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'input_token_cost'  => 0.00001,
					'output_token_cost' => 0.00003,
				)
			),
			array(
				'label'              => 'GPT-4',
				'name'               => 'gpt-4',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 4096,
				'modalities'         => array(
					'text'  => true,
					'image' => false,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => true,
					'assistants'        => true,
					'fine_tuning'       => true,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => true,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'input_token_cost'  => 0.00003,
					'output_token_cost' => 0.00006,
				)
			),
			array(
				'label'              => 'DALL·E 3',
				'name'               => 'dall-e-3',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 0,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => false,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => true,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'1024x1024_cost' => 0.0000008,
					'1024x1792_cost' => 0.0000012,
				),
			),
			array(
				'label'              => 'DALL·E 2',
				'name'               => 'dall-e-2',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 0,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => false,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => true,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'1024x1024_cost' => 0.0000004,
					'1024x1792_cost' => 0.0000008,
				),
			),
			array(
				'label'              => 'Text Embedding 3 Small',
				'name'               => 'text-embedding-3-small',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 0,
				'input_token_limit'  => 8191,
				'modalities'         => array(
					'text'  => true,
					'image' => false,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => array(
						'dimensions'    => [],
						'max_dimension' => 1536
					),
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'input_token_cost' => 0.00000002,
				),
			),
			array(
				'label'              => 'Text Embedding 3 Large',
				'name'               => 'text-embedding-3-large',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'input_token_limit'  => 8191,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 0,
				'modalities'         => array(
					'text'  => true,
					'image' => false,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => array(
						'dimensions'    => [],
						'max_dimension' => 3072
					),
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'input_token_cost' => 0.00000013,
				),
			),
			array(
				'label'              => 'Text Embedding ada 002',
				'name'               => 'text-embedding-ada-002',
				'ai_provider_id'     => Open_Ai::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 0,
				'input_token_limit'  => 8191,
				'modalities'         => array(
					'text'  => true,
					'image' => false,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => array(
						'dimensions' => [ 1536 ],
					),
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'input_token_cost' => 0.0000001,
				),
			),
		);
		foreach ( $models as $model ) {
			$metas = $model['metas'];
			unset( $model['metas'] );
			if ( AI_Model::find_by_name( $model['name'] ) ) {
				$updated = AI_Model::update( [ 'name' => $model['name'] ], $model );
				if ( $updated instanceof AI_Model ) {
					foreach ( $metas as $key => $meta ) {
						$updated->update_meta( $key, $meta );
					}
				}
			} else {
				$created = AI_Model::create( $model );
				if ( $created instanceof AI_Model ) {
					foreach ( $metas as $key => $meta ) {
						$created->update_meta( $key, $meta );
					}
				}
			}
		}
	}
}