<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Factories;

use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints\Assistant\Tools\Function_Calling;
use Limb_Chatbot\Includes\AI_Providers\Open_AI\Endpoints\Thread_Message\Thread_Message;
use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Utilities\Thread_Utility;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;

/**
 * Factory class to instantiate assistant tool handlers based on the tool call type.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai\Factories
 * @since 1.0.0
 */
class Assistant_Tool_Factory {

	/**
	 * Create an assistant tool handler instance based on the given tool call.
	 *
	 * Currently supports only 'function' type tool calls.
	 *
	 * @param  Thread_Utility  $thread_utility  Utility object for thread operations.
	 * @param  Thread_Message  $thread_message  Thread message object related to the tool call.
	 * @param  array  $tool_call  The tool call data array containing type and other information.
	 *
	 * @return Function_Calling The corresponding tool handler instance.
	 *
	 * @throws Exception If the tool call type is invalid or unsupported.
	 *
	 * @since 1.0.0
	 */
	public function make( Thread_Utility $thread_utility, Thread_Message $thread_message, $tool_call ) {
		// For now, this is always function. (others will come)
		if ( $tool_call['type'] == 'function' ) {
			return new Function_Calling( $thread_utility, $thread_message, $tool_call );
		}
		//...
		throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE, __( 'Invalid tool type', 'limb-chatbot' ) );
	}
}