<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Factories;

use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints\Assistant\RequiredActions\Submit_Tool_Outputs;
use Limb_Chatbot\Includes\AI_Providers\Open_AI\Endpoints\Thread_Message\Thread_Message;
use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Utilities\Thread_Utility;

/**
 * Factory class to create assistant required action handlers
 * based on the thread message's required action type.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai\Factories
 * @since 1.0.0
 */
class Assistant_Required_Action_Factory {

	/**
	 * Create the required action handler instance for a given thread message.
	 *
	 * @param Thread_Message $thread_message The thread message containing the required action data.
	 * @param Thread_Utility $thread_utility Utility object for thread-related operations.
	 *
	 * @return Submit_Tool_Outputs|null Returns an instance of Submit_Tool_Outputs if the action type matches,
	 *                                  otherwise returns null.
	 *
	 * @since 1.0.0
	 */
	public function make( Thread_Message $thread_message, Thread_Utility $thread_utility ) {
		if ( $thread_message->get_required_action()['type'] === 'submit_tool_outputs' ) {
			return new Submit_Tool_Outputs( $thread_utility, $thread_message, );
		}

		return null;
	}
}