<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints;

use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Handlers\Response_Handler;
use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Utilities\Vector_Store_Utility;
use Limb_Chatbot\Includes\Exceptions\Exception;


/**
 * Class Vector_Store_Endpoint
 *
 * Handles interactions with the Vector Store endpoint of the OpenAI API.
 * Supports creation of vector stores from given file IDs.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints
 * @since 1.0.0
 */
class Vector_Store_Endpoint extends Open_Ai_Endpoint {

	/**
	 * Vector_Store_Endpoint constructor.
	 *
	 * @param Vector_Store_Utility $utility Utility object providing required data and configuration.
	 * @since 1.0.0
	 */
	public function __construct( $utility ) {
		parent::__construct( $utility );
	}


	/**
	 * Creates a new vector store using file IDs obtained from the utility.
	 *
	 * @return array|null Returns the response body decoded as an array or null on failure.
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function create() {
		$body = json_encode( array(
			'file_ids' => $this->utility->get_files()
		) );
		$http_client = $this->http_client_factory();
		$res = $http_client->post( self::API_BASE_URL . '/vector_stores', array(
			'body'    => $body,
			'headers' => $this->get_header( $this->get_config(), 'assistants=v2' ),
			'timeout' => $this->utility->get_timeout()
		) );

		return ( new Response_Handler( $res, $http_client, $this ) )->get_body();
	}
}