<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints;

use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints\Response\Handlers\Response_Response_Handler;
use Limb_Chatbot\Includes\Data_Objects\File;
use Limb_Chatbot\Includes\Data_Objects\Message;

class Response_Endpoint extends Open_Ai_Endpoint {
	public function __construct( $utility ) {
		parent::__construct( $utility );
	}

	public function generate_from_file( Message $system_message, File $file ) {
		$body        = [
			'model'        => $this->utility->global_utility->get_ai_model()->get_name(),
			'input'        => [
				[
					'role'    => Message::ROLE_USER,
					'content' => [
						[
							'type'    => 'input_file',
							'file_id' => $file->get_meta( 'external_id' ),
						],
					],
				],
			],
			'temperature'  => 0.3,
			'top_p'        => 0.9,
			'instructions' => $system_message->extract_text(),
		];
		$http_client = $this->http_client_factory();
		$response    = $http_client->post( self::API_BASE_URL . '/responses', array(
			'headers' => $this->get_header(),
			'body'    => json_encode( $body ),
			'timeout' => 300,
		) );

		return ( new Response_Response_Handler( $response, $http_client, $this ) )->get_dataset_entries();
	}
}