<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints\Model\Handlers;

use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Handlers\Response_Handler;

/**
 * Class Model_Response_Handler
 *
 * Handles the response for AI Model related API requests.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints\Model\Handlers
 * @since 1.0.0
 */
class Model_Response_Handler extends Response_Handler {

	/**
	 * The AI model instance parsed from the response.
	 *
	 * @var AI_Model|null
	 * @since 1.0.0
	 */
	protected ?AI_Model $model = null;

	/**
	 * Parses the response and sets the AI model if no errors found.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function parse() {
		parent::parse();
		if ( ! $this->has_error() ) {
			$this->set_model( $this->model_factory() );
		}
	}

	/**
	 * Gets the AI model instance.
	 *
	 * @return AI_Model|null The AI model object or null if not set.
	 * @since 1.0.0
	 */
	public function get_model(): AI_Model {
		return $this->model;
	}

	/**
	 * Sets the AI model instance.
	 *
	 * @param AI_Model $model The AI model object.
	 * @return void
	 * @since 1.0.0
	 */
	public function set_model( AI_Model $model ): void {
		$this->model = $model;
	}

	/**
	 * Factory method to create the AI model instance from the response data.
	 *
	 * @return AI_Model
	 * @since 1.0.0
	 */

	protected function model_factory(): AI_Model {
		return AI_Model::make();
	}

	/**
	 * Checks if the model has been deleted successfully.
	 *
	 * @return bool True if deleted, false otherwise.
	 * @since 1.0.0
	 */
	public function is_deleted(): bool {
		return is_array( $this->get_body() ) && $this->get_body()['deleted'];
	}
}
