<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_AI\Endpoints\Chat_Completion;

use Limb_Chatbot\Includes\Data_Objects\Tool_Result_Message as Parent_Tools_Result_Message;

/**
 * Class Tool_Result_Message
 *
 * Represents the result of a tool call in a chat completion process, extending the base Tool_Result_Message.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_AI\Endpoints\Chat_Completion
 * @since 1.0.0
 */
class Tool_Result_Message extends Parent_Tools_Result_Message {

	/**
	 * The unique identifier of the related tool call.
	 *
	 * @var string
	 */
	public string $tool_call_id;

	/**
	 * Returns the tool call ID.
	 *
	 * @return string|null The tool call ID or null if not set.
	 * @since 1.0.0
	 */
	public function get_tool_call_id(): ?string {
		return $this->tool_call_id;
	}

	/**
	 * Sets the tool call ID.
	 *
	 * @param string $tool_call_id The unique ID of the tool call.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_tool_call_id( string $tool_call_id ): void {
		$this->tool_call_id = $tool_call_id;
	}
}