<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_AI\Endpoints\Chat_Completion;
use Limb_Chatbot\Includes\Data_Objects\Tool_Calls_Message as Parent_Tool_Calls_Message;

/**
 * Class Tool_Calls_Message
 *
 * Represents a message that contains tool call instructions, extending the base Tool_Calls_Message structure.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_AI\Endpoints\Chat_Completion
 * @since 1.0.0
 */
class Tool_Calls_Message extends Parent_Tool_Calls_Message {

	/**
	 * Array of tool call structures received from the completion response.
	 *
	 * @var array|null
	 */
	public ?array $tool_calls = null;

	/**
	 * Optional parsed arguments from tool calls.
	 *
	 * @var array|null
	 */
	public ?array $args = null;

	/**
	 * Get the tool calls array.
	 *
	 * @return array
	 * @since 1.0.0
	 */
	public function get_tool_calls():array {
		return $this->tool_calls;
	}

	/**
	 * Set the tool calls array.
	 *
	 * @param array|null $tool_calls Tool call data to assign.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_tool_calls( ?array $tool_calls ): void {
		$this->tool_calls = $tool_calls;
	}
}