<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints;

use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Handlers\Response_Handler;
use Limb_Chatbot\Includes\AI_Providers\Open_Ai\Utilities\Assistant_Utility;
use Limb_Chatbot\Includes\Exceptions\Exception;

/**
 * Class Assistant_Endpoint
 *
 * Handles Assistant API endpoint interactions for modifying assistant settings.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai\Endpoints
 * @since 1.0.0
 */
class Assistant_Endpoint extends Open_Ai_Endpoint {

	/**
	 * Constructor.
	 *
	 * @param Assistant_Utility $utility The utility class containing assistant-specific data and helpers.
	 *
	 * @since 1.0.0
	 */
	public function __construct( Assistant_Utility $utility ) {
		parent::__construct( $utility );
	}

	/**
	 * Modifies an assistant's instructions via OpenAI API.
	 *
	 * Sends a POST request to update the assistant's system message (instructions).
	 *
	 * @return mixed The response body from the API (usually stdClass or array).
	 *
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function modify() {
		$http_client = $this->http_client_factory();
		$response    = $http_client->post( self::API_BASE_URL . '/assistants/' . $this->utility->get_assistant_external_id(),
			[
				'headers' => $this->get_header( $this->get_config(), 'assistants=v2' ),
				'body'    => json_encode( [
					'instructions' => $this->utility->get_system_message(),
				] ),
				'timeout' => $this->utility->get_timeout()
			] );

		return ( new Response_Handler( $response, $http_client, $this ) )->get_body();
	}
}
