<?php

namespace Limb_Chatbot\Includes\AI_Providers\Open_Ai;

use Limb_Chatbot\Includes\AI_Providers\AI_Provider;
use Limb_Chatbot\Includes\Config_Dependent_Interface;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\Interfaces\File_Upload_Capable_Interface;

/**
 * OpenAI provider implementation class.
 *
 * Implements AI_Provider and Config_Dependent_Interface for OpenAI-specific functionality.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Open_Ai
 * @since 1.0.0
 */
class Open_Ai extends AI_Provider implements Config_Dependent_Interface, File_Upload_Capable_Interface {

	/**
	 * Minimum number of entries required for fine-tuning.
	 *
	 * @since 1.0.0
	 * @var int
	 */
	const FINE_TUNING_MIN_ENTRY_COUNT = 10;

	/**
	 * File extension used for fine-tuning files.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	const FINE_TUNING_FILE_EXTENSION = '.jsonl';

	/**
	 * Unique identifier for the OpenAI provider.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public static string $id = 'open-ai';

	/**
	 * Default timeout for OpenAI API requests, in seconds.
	 *
	 * @since 1.0.0
	 * @var int
	 */
	public static int $timeout = 60;

	/**
	 * Display name of the OpenAI provider.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public static string $name = 'Open_Ai';

	/**
	 * Checks if the given MIME type is supported for file uploads.
	 *
	 * @param  string  $mime_type The MIME type to check.
	 * @param  string|null  $purpose The purpose of the file (optional).
	 *
	 * @return bool
	 * @since 1.0.0
	 */
    public function supports_mime_type( string $mime_type, ?string $purpose = null ): bool {
	    $supported_mime_types = array( 'application/pdf' );

        return in_array( $mime_type, $supported_mime_types, true );
    }

	public function get_default_embedding_model() {
		return AI_Model::find_by_name( 'text-embedding-3-small' );
	}
}
