<?php

namespace Limb_Chatbot\Includes\AI_Providers\Gemini\Seeders;

use Exception;
use Limb_Chatbot\Includes\AI_Providers\Gemini\Gemini;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;

/**
 * Class AI_Models_Seeder
 *
 * Seeder class responsible for seeding AI models specific to the Gemini AI provider.
 * Creates or updates AI models with predefined configurations and metadata.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Gemini\Seeders
 * @since 1.0.0
 */
class AI_Models_Seeder {

	/**
	 * Run the seeder to create or update AI models.
	 *
	 * Iterates over a predefined list of models, creates new entries if not present,
	 * or updates existing ones. Also updates associated metadata for each model.
	 *
	 * @return void
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function run() {
		$models = array(
			array(
				'label'              => 'Gemini 2.5 Flash',
				'name'               => 'gemini-2.5-flash',
				'ai_provider_id'     => Gemini::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 65536,
				'input_token_limit'  => 1048576,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => true,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => false,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => true,
					'function_calling'   => true,
					'fine_tuning'        => false,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'input_token_cost'       => 0,
					'output_token_cost'      => 0,
					'paid_input_token_cost'  => 0.0000003,
					'paid_output_token_cost' => 0.0000025,
				)
			),
			array(
				'label'              => 'Gemini 2.5 Flash Lite',
				'name'               => 'gemini-2.5-flash-lite',
				'ai_provider_id'     => Gemini::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 65536,
				'input_token_limit'  => 1048576,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => true,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => false,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => true,
					'function_calling'   => true,
					'fine_tuning'        => false,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'input_token_cost'       => 0,
					'output_token_cost'      => 0,
					'paid_input_token_cost'  => 0.0000001,
					'paid_output_token_cost' => 0.0000004,
				)
			),
			array(
				'label'              => 'Gemini 2.5 Pro',
				'name'               => 'gemini-2.5-pro',
				'ai_provider_id'     => Gemini::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 65536,
				'input_token_limit'  => 1048576,
				'modalities'         => array(
					'text'  => true,
					'image' => true,
					'audio' => true,
				),
				'endpoints'          => array(
					'chat_completions'  => true,
					'realtime'          => false,
					'batch'             => false,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => true,
					'structured_outputs' => true,
					'distillation'       => true,
					'function_calling'   => true,
					'fine_tuning'        => false,
					'predicted_outputs'  => true,
				),
				'metas'              => array(
					'input_token_cost'       => 0,
					'output_token_cost'      => 0,
					'paid_input_token_cost'  => 0.00000125,
					'paid_output_token_cost' => 0.0000025,
				)
			),
			array(
				'label'              => 'Imagen 3.0 Generate 002',
				'name'               => 'imagen-3.0-generate-002',
				'ai_provider_id'     => Gemini::$id,
				'fine_tuned'         => false,
				'status'             => AI_Model::STATUS_ACTIVE,
				'output_token_limit' => 8192,
				'input_token_limit'  => 1048576,
				'modalities'         => array(
					'text'  => true,
					'image' => false,
					'audio' => false,
				),
				'endpoints'          => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => false,
					'embeddings'        => false,
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => true,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'           => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'              => array(
					'cost' => 0.00000003,
				)
			),
			array(
				'label'              => 'Gemini Embedding 001',
				'name'              => 'gemini-embedding-001',
				'ai_provider_id'    => Gemini::$id,
				'fine_tuned'        => false,
				'status'            => AI_Model::STATUS_ACTIVE,
				'input_token_limit' => 2048,
				'modalities'        => array(
					'text'  => true,
					'image' => false,
					'audio' => false,
				),
				'endpoints'         => array(
					'chat_completions'  => false,
					'realtime'          => false,
					'batch'             => true,
					'embeddings'        => array(
						'dimensions' => array( 3072, 1536, 768 )
					),
					'speech_generation' => false,
					'translation'       => false,
					'responses'         => false,
					'assistants'        => false,
					'fine_tuning'       => false,
					'image_generation'  => false,
					'transcription'     => false,
					'moderation'        => false
				),
				'features'          => array(
					'streaming'          => false,
					'structured_outputs' => false,
					'distillation'       => false,
					'function_calling'   => false,
					'fine_tuning'        => false,
					'predicted_outputs'  => false,
				),
				'metas'             => array(
					'input_token_cost'       => 0,
					'output_token_cost'      => 0,
					'paid_input_token_cost'  => 0.00000015,
					'paid_output_token_cost' => 0,
				)
			),
		);
		foreach ( $models as $model ) {
			$metas = $model['metas'];
			unset( $model['metas'] );
			if ( AI_Model::find_by_name( $model['name'] ) ) {
				$updated = AI_Model::update( [ 'name' => $model['name'] ], $model );
				if ( $updated instanceof AI_Model ) {
					foreach ( $metas as $key => $meta ) {
						$updated->update_meta( $key, $meta );
					}
				}
			} else {
				$created = AI_Model::create( $model );
				if ( $created instanceof AI_Model ) {
					foreach ( $metas as $key => $meta ) {
						$created->update_meta( $key, $meta );
					}
				}
			}
		}
	}
}