<?php

namespace Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Embed_Content\Handlers;

use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\AI_Providers\Gemini\Handlers\Response_Handler;

/**
 * Class Model_Response_Handler
 *
 * Handles responses related to Gemini model endpoints.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Embed_Content\Handlers
 * @since 1.0.0
 */
class Model_Response_Handler extends Response_Handler {

	/**
	 * @var AI_Model|null The AI model object parsed from the response.
	 * @since 1.0.0
	 */
	protected ?AI_Model $model = null;

	/**
	 * Parse the API response and initialize the AI model.
	 *
	 * @since 1.0.0
	 */
	public function parse() {
		parent::parse();
		if ( ! $this->has_error() ) {
			$this->set_model( $this->model_factory() );
		}
	}

	/**
	 * Get the AI model object.
	 *
	 * @return AI_Model
	 * @since 1.0.0
	 */
	public function get_model(): AI_Model {
		return $this->model;
	}

	/**
	 * Set the AI model object.
	 *
	 * @param AI_Model $model
	 * @since 1.0.0
	 */
	public function set_model( AI_Model $model ): void {
		$this->model = $model;
	}

	/**
	 * Create and return an AI model instance from the response body.
	 *
	 * @return AI_Model
	 * @since 1.0.0
	 */
	protected function model_factory(): AI_Model {
		$model = AI_Model::make();

		return $model;
	}

	/**
	 * Check whether the model has been deleted.
	 *
	 * @return bool
	 * @since 1.0.0
	 */
	public function is_deleted(): bool {
		return false;
		// TODO implement
	}
}