<?php

namespace Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints;

use Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Embed_Content\Handlers\Model_Response_Handler;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;

/**
 * Class Model_Endpoint
 *
 * Handles model-related actions for Gemini, such as listing available models.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints
 * @since 1.0.0
 */
class Model_Endpoint extends Gemini_Endpoint {

	/**
	 * Model_Endpoint constructor.
	 *
	 * @param mixed $utility Utility object containing configuration and tools.
	 * @since 1.0.0
	 */
	public function __construct( $utility ) {
		parent::__construct( $utility );
	}

	/**
	 * Retrieve a specific model.
	 *
	 * @throws Exception Always, because not implemented.
	 * @since 1.0.0
	 */
	public function retrieve() {
		throw new Exception( Error_Codes::GEMINI_ERROR, __( 'Missing implementation', 'limb-chatbot' ) );
	}

	/**
	 * List all available models for the Gemini provider.
	 *
	 * @return array List of models.
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function list() {
		$http_client = $this->http_client_factory();
		$response    = $http_client->get( Gemini_Endpoint::API_BASE_URL . 'v1beta/models?key=' . $this->get_auth_key(), [
			'headers' => $this->get_header(),
			'timeout' => $this->utility->get_timeout(),
		] );
		// TODO later maybe will be good to change the body type from inside the Gemini/Response_Handler to array
		return (array) ( new Model_Response_Handler( $response, $http_client, $this ) )->get_body();
	}

	/**
	 * Delete a model.
	 *
	 * @throws Exception Always, because not implemented.
	 * @since 1.0.0
	 */
	public function delete() {
		throw new Exception( Error_Codes::GEMINI_ERROR, __( 'Missing implementation', 'limb-chatbot' ) );
	}
}