<?php

namespace Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Generate_Content;

use Limb_Chatbot\Includes\Data_Objects\Tool_Result_Message as Parent_Tools_Result_Message;


/**
 * Class Tool_Result_Message
 *
 * Represents a Gemini-specific tool result message that supports structured parts.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Generate_Content
 * @since 1.0.0
 */
class Tool_Result_Message extends Parent_Tools_Result_Message {
	/**
	 * The structured message parts.
	 *
	 * @var array|null
	 * @since 1.0.0
	 */
	public ?array $parts;

	/**
	 * Set the structured parts of the tool result message.
	 *
	 * @param  array|null  $parts  Array of message parts.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_parts( ?array $parts ): void {
		$this->parts = $parts;
	}

	/**
	 * Get the structured parts of the tool result message.
	 *
	 * @return array|null Array of message parts or null.
	 * @since 1.0.0
	 */
	public function get_parts(): ?array {
		return $this->parts;
	}
}