<?php

namespace Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Generate_Content;
use Limb_Chatbot\Includes\Data_Objects\Tool_Calls_Message as Parent_Tool_Calls_Message;

/**
 * Class Tool_Calls_Message
 *
 * Represents a Gemini-specific tool call message with extended support for structured parts.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Gemini\Endpoints\Generate_Content
 * @since 1.0.0
 */
class Tool_Calls_Message extends Parent_Tool_Calls_Message {

	/**
	 * Message parts array.
	 *
	 * @var array|null
	 * @since 1.0.0
	 */
	public ?array $parts;

	/**
	 * Set the structured parts of the tool call message.
	 *
	 * @param array|null $parts
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function set_parts( ?array $parts ): void {
		$this->parts = $parts;
	}

	/**
	 * Get the structured parts of the tool call message.
	 *
	 * @return array|null
	 * @since 1.0.0
	 */
	public function get_parts(): ?array {
		return $this->parts;
	}
}