<?php

namespace Limb_Chatbot\Includes\AI_Providers\Gemini\Data_Schemas;

use Limb_Chatbot\Includes\AI_Providers\Gemini\Gemini;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Scheme_Interface;
use Limb_Chatbot\Includes\Data_Objects\Setting as Setting_Data_Object;

/**
 * Class Setting
 *
 * Defines validation rules and default values for Gemini AI provider settings.
 *
 * @since 1.0.0
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Gemini\Data_Schemas
 */
class Setting implements Scheme_Interface {

	/**
	 * Returns an array of setting validation rules.
	 *
	 * @since 1.0.0
	 *
	 * @return array<string, array<string, mixed>> Array of settings keys with validation and metadata.
	 */
	public static function rules(): array {
		$prefix = Setting_Data_Object::SETTING_PREFIX . 'ai_providers.' . Gemini::$id;

		return [
			$prefix . '.utilities.chatbot.ai_model_id'     => [
				'name'              => __( 'Chatbot model id', 'limb-chatbot' ),
				'type'              => 'integer',
				'default'           => ( $model = AI_Model::find_by_name( 'gemini-2.5-flash' ) ) ? $model->get_id() : null,
				'validate_callback' => function ( $value ): bool {
					return (bool) AI_Model::count( [ 'id' => $value ] );
				},
				'required'          => true
			],
			$prefix . '.utilities.chatbot.config_id'       => [
				'type'              => 'integer',
				'name'              => __( 'Chatbot API Key', 'limb-chatbot' ),
				'required'          => false,
				'validate_callback' => function ( $value ): bool {
					return (bool) Config::count( [ 'id' => $value ] );
				},
			],
			$prefix . '.utilities.embedding.dimension'        => [
				'name'     => __( 'Embedding dimension', 'limb-chatbot' ),
				'type'     => 'integer',
				'default'  => 1536,
				'required' => true,
			],
			$prefix . '.utilities.embedding.encoding_format' => [
				'name'     => __( 'Embedding encoding format', 'limb-chatbot' ),
				'type'     => 'string',
				'default'  => 'float',
				'enum'     => [ 'float' ],
				'required' => true,
			],
			$prefix . '.utilities.embedding.ai_model_id'     => [
				'name'              => __( 'Embedding model id', 'limb-chatbot' ),
				'type'              => 'integer',
				'default'           => ( $model = AI_Model::find_by_name( 'gemini-embedding-001' ) ) ? $model->get_id() : null,
				'validate_callback' => function ( $value ): bool {
					return (bool) AI_Model::count( [ 'id' => $value ] );
				},
				'required'          => true
			],
			$prefix . '.utilities.embedding.config_id'       => [
				'type'              => 'integer',
				'name'              => __( 'Embedding API Key', 'limb-chatbot' ),
				'required'          => false,
				'validate_callback' => function ( $value ): bool {
					return (bool) Config::count( [ 'id' => $value ] );
				},
			],
			$prefix . '.utilities.copilot.ai_model_id'     => [
				'name'              => __( 'Copilot model id', 'limb-chatbot' ),
				'type'              => 'integer',
				'default'           => ( $model = AI_Model::find_by_name( 'gemini-2.5-flash' ) ) ? $model->get_id() : null,
				'validate_callback' => function ( $value ): bool {
					return (bool) AI_Model::count( [ 'id' => $value ] );
				},
				'required'          => true
			],
			$prefix . '.utilities.copilot.config_id'       => [
				'type'              => 'integer',
				'name'              => __( 'Copilot API Key', 'limb-chatbot' ),
				'required'          => false,
				'validate_callback' => function ( $value ): bool {
					return (bool) Config::count( [ 'id' => $value ] );
				},
			],
		];
	}
}