<?php

namespace Limb_Chatbot\Includes\AI_Providers\Deep_Seek\Endpoints\Chat_Completion;
use Limb_Chatbot\Includes\Data_Objects\Tool_Result_Message as Parent_Tools_Result_Message;

/**
 * Class Tool_Result_Message
 *
 * Extends the base Tool_Result_Message Data Object for Deep Seek Chat Completion.
 * Represents a tool result with an associated tool call ID.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Deep_Seek\Endpoints\Chat_Completion
 * @since 1.0.0
 */
class Tool_Result_Message extends Parent_Tools_Result_Message {

	/**
	 * Identifier for the related tool call.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public string $tool_call_id;

	/**
	 * Get the tool call ID.
	 *
	 * @since 1.0.0
	 *
	 * @return string|null The tool call identifier.
	 */
	public function get_tool_call_id(): ?string {
		return $this->tool_call_id;
	}

	/**
	 * Set the tool call ID.
	 *
	 * @since 1.0.0
	 *
	 * @param string $tool_call_id The tool call identifier.
	 * @return void
	 */
	public function set_tool_call_id( string $tool_call_id ): void {
		$this->tool_call_id = $tool_call_id;
	}
}