<?php

namespace Limb_Chatbot\Includes\AI_Providers\Deep_Seek\Endpoints\Chat_Completion;
use Limb_Chatbot\Includes\Data_Objects\Tool_Calls_Message as Parent_Tool_Calls_Message;

/**
 * Class Tool_Calls_Message
 *
 * Extends the base Tool_Calls_Message Data Object for Deep Seek Chat Completion.
 * Handles tool calls and their arguments.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Deep_Seek\Endpoints\Chat_Completion
 * @since 1.0.0
 */
class Tool_Calls_Message extends Parent_Tool_Calls_Message {

	/**
	 * Array of tool call data.
	 *
	 * @since 1.0.0
	 * @var array|null
	 */
	public ?array $tool_calls;

	/**
	 * Optional arguments for tool calls.
	 *
	 * @since 1.0.0
	 * @var array|null
	 */
	public ?array $args;

	/**
	 * Get the tool calls array.
	 *
	 * @since 1.0.0
	 *
	 * @return array|null Tool calls data.
	 */
	public function get_tool_calls(): ?array {
		return $this->tool_calls;
	}

	/**
	 * Set the tool calls array.
	 *
	 * @since 1.0.0
	 *
	 * @param array|null $tool_calls Tool calls data.
	 * @return void
	 */
	public function set_tool_calls(?array $tool_calls): void {
		$this->tool_calls = $tool_calls;
	}
}