<?php

namespace Limb_Chatbot\Includes\AI_Providers\Claude\Data_Schemas;

use Limb_Chatbot\Includes\AI_Providers\Claude\Claude;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Data_Objects\Setting as Setting_Data_Object;
use Limb_Chatbot\Includes\Scheme_Interface;

/**
 * Class Setting
 *
 * Defines validation rules and default values for Claude AI provider settings.
 * Note: Claude only supports chatbot functionality - no embeddings or fine-tuning.
 *
 * @package Limb_Chatbot\Includes\AI_Providers\Claude\Data_Schemas
 * @since 1.0.9
 */
class Setting implements Scheme_Interface {

	/**
	 * Returns an array of setting validation rules.
	 *
	 * @return array<string, array<string, mixed>> Array of settings keys with validation and metadata.
	 * @since 1.0.9
	 */
	public static function rules(): array {
		$prefix = Setting_Data_Object::SETTING_PREFIX . 'ai_providers.' . Claude::$id;

		return array(
			$prefix . '.utilities.chatbot.ai_model_id' => array(
				'name'              => __( 'Chatbot model id', 'limb-chatbot' ),
				'type'              => 'integer',
				'default'           => ( $model = AI_Model::find_by_name( 'claude-haiku-4-5' ) ) ? $model->get_id() : null,
				'validate_callback' => function ( $value ): bool {
					return (bool) AI_Model::count( array( 'id' => $value ) );
				},
				'required'          => true,
			),
			$prefix . '.utilities.chatbot.config_id'   => array(
				'type'              => 'integer',
				'name'              => __( 'Chatbot API Key', 'limb-chatbot' ),
				'required'          => false,
				'validate_callback' => function ( $value ): bool {
					return (bool) Config::count( array( 'id' => $value ) );
				},
			),
			$prefix . '.utilities.copilot.ai_model_id' => array(
				'name'              => __( 'Copilot model id', 'limb-chatbot' ),
				'type'              => 'integer',
				'default'           => ( $model = AI_Model::find_by_name( 'claude-haiku-4-5' ) ) ? $model->get_id() : null,
				'validate_callback' => function ( $value ): bool {
					return (bool) AI_Model::count( array( 'id' => $value ) );
				},
				'required'          => true,
			),
			$prefix . '.utilities.copilot.config_id'   => array(
				'type'              => 'integer',
				'name'              => __( 'Copilot API Key', 'limb-chatbot' ),
				'required'          => false,
				'validate_callback' => function ( $value ): bool {
					return (bool) Config::count( array( 'id' => $value ) );
				},
			),
		);
	}
}

