<?php

namespace Limb_Chatbot\Includes\Admin\Pages\Notifications;

use Limb_Chatbot\Includes\Admin\Admin;
use Limb_Chatbot\Includes\Admin\Pages\Setting;

/**
 * Class Page
 *
 * Handles the Actions submenu page for the Limb Chatbot plugin.
 * Responsible for rendering the actions page, enqueuing assets, and rendering a live chatbot preview.
 *
 * @package Limb_Chatbot\Includes\Admin\Pages\Actions
 * @since 1.0.0
 */
class Page {
	/**
	 * Reference to the settings page responsible for rendering and assets.
	 *
	 * @since 1.0.0
	 * @var Setting\Page
	 */
	protected Setting\Page $setting_page;

	/**
	 * Menu slug for the actions page.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public static string $menu_slug = 'lbaic-dashboard&menu=notifications';

	/**
	 * Constructor.
	 *
	 * @param Setting\Page $setting_page Instance responsible for rendering the page and handling styles/scripts.
	 *
	 * @since 1.0.0
	 *
	 */
	public function __construct( Setting\Page $setting_page ) {
		$this->setting_page = $setting_page;
	}

	/**
	 * Adds the "Actions" submenu page under the main "Limb" admin menu.
	 * Also hooks required scripts and styles for the actions page.
	 *
	 * @return void
	 * @since 1.0.0
	 *
	 */
	public function add_submenu_page() {
		$actions = add_submenu_page(
			Admin::$menu_slug,
			__( 'Notifications', 'limb-chatbot' ),
			__( 'Notifications', 'limb-chatbot' ),
			'manage_options',
			static::$menu_slug,
			array(
				$this->setting_page,
				'render'
			),
			9
		);

		add_action( 'admin_print_scripts-' . $actions, array( $this, 'scripts' ) );
		add_action( 'admin_print_styles-' . $actions, array( $this, 'styles' ) );
		add_action( 'load-' . $actions, array( $this, 'add_screen_options' ) );
		add_action( 'load-' . $actions, array( $this, 'remove_notices' ) );
	}
}
