<?php

namespace Limb_Chatbot\Includes\Admin\Pages\Default_Chatbot;

use Limb_Chatbot\Includes\Admin\Admin;
use Limb_Chatbot\Includes\Admin\Pages\Setting;

/**
 * Class Page
 *
 * Registers the "Default Chatbot" admin submenu under the "Limb" menu and manages its rendering.
 * Connects to a Setting Page instance that handles the UI and scripts/styles for the page.
 *
 * @package Limb_Chatbot\Includes\Admin\Pages\Default_Chatbot
 * @since 1.0.0
 */
class Page {

	/**
	 * Reference to the settings page responsible for rendering and assets.
	 *
	 * @since 1.0.0
	 * @var Setting\Page
	 */
	protected Setting\Page $setting_page;

	/**
	 * Slug identifier for the default chatbot admin submenu.
	 *
	 * @since 1.0.0
	 * @var string
	 */
	static string $menu_slug = 'lbaic-dashboard';

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 *
	 * @param Setting\Page $setting_page Instance responsible for rendering the page and handling styles/scripts.
	 */
	public function __construct( Setting\Page $setting_page ) {
		$this->setting_page = $setting_page;
	}

	/**
	 * Adds the "Default Chatbot" submenu under the "Limb" admin menu.
	 *
	 * Registers render and assets (scripts/styles) callbacks via `add_action`.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function add_submenu_page() {
		$default_chatbot = add_submenu_page(
			Admin::$menu_slug,
			__( 'Default Chatbot', 'limb-chatbot' ),
			__( 'Chatbot', 'limb-chatbot' ),
			'manage_options',
			static::$menu_slug,
			array(
				$this->setting_page,
				'render'
			),
			2
		);

		add_action( 'admin_print_scripts-' . $default_chatbot, array( $this->setting_page, 'scripts' ) );
		add_action( 'admin_print_styles-' . $default_chatbot, array( $this->setting_page, 'styles' ) );
		add_action( 'load-' . $default_chatbot, array( $this->setting_page, 'add_screen_options' ) );
		add_action( 'load-' . $default_chatbot, array( $this->setting_page, 'remove_notices' ) );
	}
}