<?php

namespace Limb_Chatbot\Includes\Admin;

/**
 * Class Ajax
 *
 * Handles AJAX-related functionality for the Limb Chatbot plugin in the admin area.
 * Responsible for registering and managing AJAX actions/hooks.
 *
 * @package Limb_Chatbot\Includes\Admin
 * @since 1.0.0
 */
class Ajax {

	/**
	 * List of registered AJAX action hooks.
	 *
	 * @since 1.0.0
	 * @var array
	 */
	protected static array $actions = [];

	/**
	 * Initialize the AJAX handler.
	 *
	 * Registers necessary hooks and prepares AJAX actions.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function init(): void {
		self::define_hooks();
	}

	/**
	 * Define and register AJAX action hooks.
	 *
	 * This method should add actions for AJAX calls using add_action().
	 * Currently empty and should be extended as needed.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	private static function define_hooks() {
	}
}

