<?php

namespace Limb_Chatbot\Includes\Admin;

use Limb_Chatbot\Includes\Traits\SingletonTrait;

/**
 * Class Assets
 *
 * Handles admin asset registration (CSS/JS) for the Limb Chatbot plugin.
 * Uses WordPress hooks to enqueue styles, scripts, and editor assets.
 *
 * @package Limb_Chatbot\Includes\Admin
 * @since 1.0.0
 */
class Assets {

	use SingletonTrait;

	/**
	 * Initialize admin-related asset hooks.
	 *
	 * Registers all action hooks related to enqueuing scripts/styles
	 * in the WordPress admin and block editor.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function admin_init() {
		$instance = self::instance();
		add_action( 'admin_enqueue_scripts', array( $instance, 'styles' ) );
		add_action( 'admin_enqueue_scripts', array( $instance, 'scripts' ) );
		add_action( 'enqueue_block_editor_assets', array( $instance, 'block_editor_scripts' ) );
		add_action( 'admin_footer', array( $instance, 'add_icons_utilities_to_admin' ) );
	}

	/**
	 * Enqueue block editor assets (Gutenberg).
	 *
	 * Empty for now. Can be extended to load block scripts/styles in the editor.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function block_editor_scripts() {
	}

	/**
	 * Enqueue admin stylesheets.
	 *
	 * Intended to register and enqueue plugin-specific CSS for the admin panel.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function styles() {
	}

	/**
	 * Enqueue admin JavaScript files.
	 *
	 * Intended to register and enqueue plugin-specific JS for the admin panel.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function scripts() {
	}

	/**
	 * Output the chatbot icons utilities SVG in admin pages.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function add_icons_utilities_to_admin() {
		// Check if we're on the right admin pages
		$should_load_icons = false;

		// Limb dashboard admin page
		if ( isset( $_GET['page'] ) && sanitize_text_field( wp_unslash( $_GET['page'] ) ) === 'lbaic-dashboard' ) {
			$should_load_icons = true;
		}

		// Load the icons utilities
		if ( $should_load_icons ) {
			$plugin_dir_path = Limb_Chatbot()->get_plugin_dir_path();

			include $plugin_dir_path . 'templates/chatbot/lbaic-chatbot-icons.php';
		}
	}
}